/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.DonationKey;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.aquaticprime.Receipt;
import ch.cyberduck.core.aquaticprime.ReceiptVerifier;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DonationKeyFactory
extends LicenseFactory {
    private static final Logger log = LogManager.getLogger(DonationKeyFactory.class);

    @Override
    protected License create() {
        return new LicenseFactory.DefaultLicenseFactory(this).create();
    }

    @Override
    protected License open(Local file) {
        return new DonationKey(file);
    }

    @Override
    public List<License> open() throws AccessDeniedException {
        Local bundle;
        List<License> keys = super.open();
        if (keys.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("No donation key found");
            }
            final Pattern pattern = Pattern.compile(".*\\.cyberduckreceipt");
            for (Local file : SupportDirectoryFinderFactory.get().find().list().filter(new Filter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return "cyberduckreceipt".equals(Path.getExtension(file.getName()));
                }

                @Override
                public Pattern toPattern() {
                    return pattern;
                }
            })) {
                ReceiptVerifier verifier = new ReceiptVerifier(file);
                if (!verifier.verify(new DisabledLicenseVerifierCallback())) continue;
                keys.add(new Receipt(file, verifier.getGuid()));
            }
        }
        if (keys.isEmpty() && (bundle = ApplicationResourcesFinderFactory.get().find()).exists()) {
            for (Local key : bundle.list().filter(new LicenseFactory.LicenseFilter())) {
                log.info(String.format("Add bundled registration key %s", key));
                License registration = this.open(key);
                keys.add(registration);
            }
        }
        if (keys.isEmpty()) {
            return Collections.singletonList(LicenseFactory.EMPTY_LICENSE);
        }
        return keys;
    }
}

