/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.TimeZone;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDateFormatterFactory
extends Factory<AbstractUserDateFormatter> {
    private static final Logger log = LogManager.getLogger(UserDateFormatterFactory.class);
    private Constructor<? extends AbstractUserDateFormatter> constructor;

    protected UserDateFormatterFactory() {
        super("factory.dateformatter.class");
    }

    public AbstractUserDateFormatter create(String timezone) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{timezone.getClass()});
            }
            if (null == this.constructor) {
                log.warn(String.format("No matching constructor for parameter %s", timezone.getClass()));
                return (AbstractUserDateFormatter)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.constructor.newInstance(timezone);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static AbstractUserDateFormatter get() {
        return UserDateFormatterFactory.get(TimeZone.getDefault().getID());
    }

    public static AbstractUserDateFormatter get(String tz) {
        return new UserDateFormatterFactory().create(tz);
    }
}

