/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class URIEncoder {
    private static final Logger log = LogManager.getLogger(URIEncoder.class);

    private URIEncoder() {
    }

    public static String encode(String input) {
        try {
            StringBuilder b = new StringBuilder();
            StringTokenizer t = new StringTokenizer(input, "/");
            if (!t.hasMoreTokens()) {
                return input;
            }
            if (StringUtils.startsWith((CharSequence)input, (CharSequence)String.valueOf('/'))) {
                b.append('/');
            }
            while (t.hasMoreTokens()) {
                b.append(URLEncoder.encode(t.nextToken(), StandardCharsets.UTF_8.name()));
                if (!t.hasMoreTokens()) continue;
                b.append('/');
            }
            if (StringUtils.endsWith((CharSequence)input, (CharSequence)String.valueOf('/'))) {
                b.append('/');
            }
            return StringUtils.replaceEach((String)b.toString(), (String[])new String[]{"+", "*", "%7E", "%40"}, (String[])new String[]{"%20", "%2A", "~", "@"});
        }
        catch (UnsupportedEncodingException e) {
            log.warn(String.format("Failure %s encoding input %s", e, input));
            return input;
        }
    }

    public static String decode(String input) {
        try {
            return URLDecoder.decode(input, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            log.warn(String.format("Failure %s decoding input %s", e, input));
            return input;
        }
    }
}

