/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.transfer.DisabledTransferErrorCallback;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransferErrorCallbackControllerFactory
extends Factory<TransferErrorCallback> {
    private static final Logger log = LogManager.getLogger(TransferErrorCallbackControllerFactory.class);

    public TransferErrorCallbackControllerFactory() {
        super("factory.transfererrorcallback.class");
    }

    public TransferErrorCallback create(Controller c) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{c.getClass()});
            if (null == constructor) {
                log.warn(String.format("No matching constructor for parameter %s", c.getClass()));
                return (TransferErrorCallback)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (TransferErrorCallback)constructor.newInstance(c);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledTransferErrorCallback();
        }
    }

    public static TransferErrorCallback get(Controller c) {
        final TransferErrorCallback proxy = new TransferErrorCallbackControllerFactory().create(c);
        return new TransferErrorCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean prompt(TransferItem item, TransferStatus status, BackgroundException failure, int pending) throws BackgroundException {
                switch (new DefaultFailureDiagnostics().determine(failure)) {
                    case cancel: 
                    case skip: {
                        return false;
                    }
                }
                if (pending == 0) {
                    throw failure;
                }
                if (pending == 1) {
                    throw failure;
                }
                TransferErrorCallback transferErrorCallback = proxy;
                synchronized (transferErrorCallback) {
                    return proxy.prompt(item, status, failure, pending);
                }
            }
        };
    }
}

