/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SessionFactory {
    private static final Logger log = LogManager.getLogger(SessionFactory.class);

    private SessionFactory() {
    }

    public static Session<?> create(Host host, X509TrustManager trust, X509KeyManager key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create session for %s", host));
        }
        Protocol protocol = host.getProtocol();
        String prefix = protocol.getPrefix();
        try {
            Session session;
            Class<?> name = Class.forName(String.format("%sSession", prefix));
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{host.getClass(), trust.getClass(), key.getClass()});
            if (null == constructor) {
                log.warn(String.format("No matching constructor for parameter %s, %s, %s", host.getClass(), trust.getClass(), key.getClass()));
                Constructor fallback = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{host.getClass()});
                if (fallback == null) {
                    throw new FactoryException(String.format("No matching constructor for parameter %s", host.getClass()));
                }
                session = (Session)fallback.newInstance(host);
            } else {
                session = (Session)constructor.newInstance(host, trust, key);
            }
            return session;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(String.format("Failure loading session class for %s protocol. Failure %s", protocol, e));
        }
    }
}

