/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.profiles.LocalProfilesFinder;
import ch.cyberduck.core.profiles.ProfileDescription;
import ch.cyberduck.core.profiles.ProfilesFinder;
import ch.cyberduck.core.serializer.impl.dd.ProfilePlistReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ProtocolFactory {
    private static final Logger log = LogManager.getLogger(ProtocolFactory.class);
    private static final ProtocolFactory global = new ProtocolFactory();
    private final Preferences preferences = PreferencesFactory.get();
    public static final Predicate<Protocol> DEFAULT_PROTOCOL_PREDICATE = protocol -> !protocol.isEnabled() && !protocol.isBundled();
    public static final Predicate<Protocol> BUNDLED_PROFILE_PREDICATE = protocol -> protocol.isEnabled() && protocol.isBundled();
    private final Set<Protocol> registered;
    private final Local bundle;
    private final Local profiles;

    public static ProtocolFactory get() {
        return global;
    }

    public ProtocolFactory() {
        this(new LinkedHashSet<Protocol>());
    }

    public ProtocolFactory(Set<Protocol> registered) {
        this(registered, LocalFactory.get(ApplicationResourcesFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name")), LocalFactory.get(SupportDirectoryFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name")));
    }

    public ProtocolFactory(Set<Protocol> registered, Local bundle, Local profiles) {
        this.registered = new HashSet<Protocol>(registered);
        this.bundle = bundle;
        this.profiles = profiles;
    }

    public void register(Protocol ... protocols) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Register protocols %s", Arrays.toString(protocols)));
        }
        Collections.addAll(this.registered, protocols);
    }

    public void load() {
        this.load(new LocalProfilesFinder(this, this.bundle, DEFAULT_PROTOCOL_PREDICATE));
        this.load(new LocalProfilesFinder(this, this.profiles, BUNDLED_PROFILE_PREDICATE));
    }

    public void load(ProfilesFinder finder) {
        try {
            for (ProfileDescription description : finder.find()) {
                Optional<Profile> profile = description.getProfile();
                profile.ifPresent(this.registered::add);
            }
        }
        catch (BackgroundException e) {
            log.warn(String.format("Failure %s reading profiles from %s", finder, e));
        }
    }

    public Local register(Local file) {
        try {
            Profile profile = (Profile)new ProfilePlistReader(this, BUNDLED_PROFILE_PREDICATE).read(file);
            if (null == profile) {
                log.error("Attempt to register unknown protocol");
                return null;
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("Register profile %s", profile));
            }
            this.registered.add(profile);
            this.preferences.setProperty(StringUtils.lowerCase((String)String.format("profiles.%s.%s.enabled", profile.getProtocol(), profile.getProvider())), true);
            if (!this.profiles.exists()) {
                new DefaultLocalDirectoryFeature().mkdir(this.profiles);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Save profile %s to %s", profile, this.profiles));
            }
            if (!file.isChild(this.profiles)) {
                Local target = LocalFactory.get(this.profiles, file.getName());
                file.copy(target);
                return target;
            }
            return file;
        }
        catch (AccessDeniedException e) {
            log.error(String.format("Failure %s reading profile %s", e, file));
            return null;
        }
    }

    public void unregister(Profile profile) {
        if (this.registered.remove(profile)) {
            this.preferences.setProperty(StringUtils.lowerCase((String)String.format("profiles.%s.%s.enabled", profile.getProtocol(), profile.getProvider())), false);
        } else {
            log.warn(String.format("Failure removing protocol %s", profile));
        }
    }

    public List<Protocol> find() {
        return this.find(Protocol::isEnabled);
    }

    public List<Protocol> find(Predicate<Protocol> search) {
        return this.registered.stream().filter(search).sorted().collect(Collectors.toList());
    }

    public Protocol forName(String identifier) {
        return this.forName(identifier, null);
    }

    public Protocol forName(String identifier, String provider) {
        return this.forName(this.find(), identifier, provider);
    }

    public Protocol forName(List<Protocol> enabled, String identifier, String provider) {
        Protocol match = enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> String.valueOf(protocol.hashCode()).equals(identifier)).findFirst().orElse(enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> StringUtils.equals((CharSequence)protocol.getIdentifier(), (CharSequence)identifier) && StringUtils.equals((CharSequence)protocol.getProvider(), (CharSequence)provider)).findFirst().orElse(enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> StringUtils.equals((CharSequence)protocol.getProvider(), (CharSequence)identifier)).findFirst().orElse(enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> StringUtils.equals((CharSequence)String.format("%s-%s", protocol.getIdentifier(), protocol.getProvider()), (CharSequence)identifier)).findFirst().orElse(enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> protocol.isBundled() && StringUtils.equals((CharSequence)protocol.getIdentifier(), (CharSequence)identifier)).findFirst().orElse(this.forScheme(enabled, identifier, enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> StringUtils.equals((CharSequence)protocol.getType().name(), (CharSequence)identifier)).findFirst().orElse(null)))))));
        if (null == match) {
            if (enabled.isEmpty()) {
                log.error(String.format("List of registered protocols in %s is empty", this));
            }
            log.warn(String.format("Missing registered protocol for identifier %s", identifier));
        }
        return match;
    }

    public Protocol forType(Protocol.Type type) {
        List<Protocol> enabled = this.find();
        return this.forType(enabled, type);
    }

    private Protocol forType(List<Protocol> enabled, Protocol.Type type) {
        return enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> protocol.getType().equals((Object)type)).findFirst().orElse(null);
    }

    public Protocol forScheme(Scheme scheme) {
        return this.forScheme(scheme.name(), null);
    }

    public Protocol forScheme(String scheme, Protocol fallback) {
        return this.forScheme(this.find(), scheme, fallback);
    }

    private Protocol forScheme(List<Protocol> enabled, String scheme, Protocol fallback) {
        String filter;
        switch (scheme) {
            case "http": {
                filter = Scheme.dav.name();
                break;
            }
            case "https": {
                filter = Scheme.davs.name();
                break;
            }
            default: {
                filter = scheme;
            }
        }
        return enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> Arrays.asList(protocol.getSchemes()).contains(filter)).findFirst().orElse(enabled.stream().sorted(new DeprecatedProtocolComparator()).filter(protocol -> Arrays.asList(protocol.getSchemes()).contains(scheme)).findFirst().orElse(fallback));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProtocolFactory{");
        sb.append("registered=").append(this.registered);
        sb.append(", bundle=").append(this.bundle);
        sb.append(", profiles=").append(this.profiles);
        sb.append('}');
        return sb.toString();
    }

    private static final class DeprecatedProtocolComparator
    implements Comparator<Protocol> {
        private DeprecatedProtocolComparator() {
        }

        @Override
        public int compare(Protocol o1, Protocol o2) {
            return Boolean.compare(o1.isDeprecated(), o2.isDeprecated());
        }
    }
}

