/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.serializer.Serializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathAttributes
extends Attributes
implements Serializable {
    private static final Logger log = LogManager.getLogger(PathAttributes.class);
    public static final PathAttributes EMPTY = new PathAttributes();
    private long size = -1L;
    private long quota = -1L;
    private long modified = -1L;
    private long accessed = -1L;
    private long created = -1L;
    private String owner;
    private String group;
    private Permission permission = Permission.EMPTY;
    private Acl acl = Acl.EMPTY;
    private Checksum checksum = Checksum.NONE;
    private String etag;
    private String storageClass;
    private Encryption.Algorithm encryption = Encryption.Algorithm.NONE;
    private String fileId;
    private String versionId;
    private String lockId;
    private Boolean duplicate;
    private Boolean hidden;
    private Long revision;
    private String region;
    private String displayname;
    private DescriptiveUrl link = DescriptiveUrl.EMPTY;
    private Map<String, String> metadata = Collections.emptyMap();
    private Path vault;
    private Path decrypted;
    private Path encrypted;
    private String directoryId;
    private Map<String, String> custom = Collections.emptyMap();

    public PathAttributes() {
    }

    public PathAttributes(PathAttributes copy) {
        this.size = copy.size;
        this.quota = copy.quota;
        this.modified = copy.modified;
        this.accessed = copy.accessed;
        this.created = copy.created;
        this.owner = copy.owner;
        this.group = copy.group;
        this.permission = Permission.EMPTY == copy.permission ? Permission.EMPTY : new Permission(copy.permission);
        this.acl = Acl.EMPTY == copy.acl ? Acl.EMPTY : new Acl(copy.acl);
        this.checksum = Checksum.NONE == copy.checksum ? Checksum.NONE : new Checksum(copy.checksum);
        this.etag = copy.etag;
        this.storageClass = copy.storageClass;
        this.encryption = copy.encryption;
        this.fileId = copy.fileId;
        this.versionId = copy.versionId;
        this.lockId = copy.lockId;
        this.duplicate = copy.duplicate;
        this.hidden = copy.hidden;
        this.revision = copy.revision;
        this.region = copy.region;
        this.displayname = copy.displayname;
        this.link = DescriptiveUrl.EMPTY == copy.link ? DescriptiveUrl.EMPTY : new DescriptiveUrl(copy.link);
        this.metadata = new HashMap<String, String>(copy.metadata);
        this.custom = new HashMap<String, String>(copy.custom);
        this.vault = copy.vault;
        this.decrypted = copy.decrypted;
        this.encrypted = copy.encrypted;
        this.directoryId = copy.directoryId;
    }

    @Override
    public <T> T serialize(Serializer<T> dict) {
        HashMap<String, String> wrapper;
        if (this.size != -1L) {
            dict.setStringForKey(String.valueOf(this.size), "Size");
        }
        if (this.quota != -1L) {
            dict.setStringForKey(String.valueOf(this.quota), "Quota");
        }
        if (this.modified != -1L) {
            dict.setStringForKey(String.valueOf(this.modified), "Modified");
        }
        if (this.created != -1L) {
            dict.setStringForKey(String.valueOf(this.created), "Created");
        }
        if (this.revision != null) {
            dict.setStringForKey(String.valueOf(this.revision), "Revision");
        }
        if (this.etag != null) {
            dict.setStringForKey(this.etag, "ETag");
        }
        if (this.permission != Permission.EMPTY) {
            dict.setObjectForKey(this.permission, "Permission");
        }
        if (this.acl != Acl.EMPTY) {
            dict.setObjectForKey(this.acl, "Acl");
        }
        if (this.link != DescriptiveUrl.EMPTY) {
            wrapper = new HashMap<String, String>();
            wrapper.put("Url", this.link.getUrl());
            wrapper.put("Type", this.link.getType().name());
            dict.setMapForKey(wrapper, "Link");
        }
        if (this.checksum != Checksum.NONE) {
            wrapper = new HashMap();
            wrapper.put("Algorithm", this.checksum.algorithm.name());
            wrapper.put("Hash", this.checksum.hash);
            dict.setMapForKey(wrapper, "Checksum");
        }
        if (StringUtils.isNotBlank((CharSequence)this.versionId)) {
            dict.setStringForKey(this.versionId, "Version");
        }
        if (StringUtils.isNotBlank((CharSequence)this.fileId)) {
            dict.setStringForKey(this.fileId, "File Id");
        }
        if (StringUtils.isNotBlank((CharSequence)this.lockId)) {
            dict.setStringForKey(this.lockId, "Lock Id");
        }
        if (this.duplicate != null) {
            dict.setStringForKey(String.valueOf(this.duplicate), "Duplicate");
        }
        if (this.hidden != null) {
            dict.setStringForKey(String.valueOf(this.hidden), "Hidden");
        }
        if (StringUtils.isNotBlank((CharSequence)this.region)) {
            dict.setStringForKey(this.region, "Region");
        }
        if (StringUtils.isNotBlank((CharSequence)this.storageClass)) {
            dict.setStringForKey(this.storageClass, "Storage Class");
        }
        if (this.vault != null) {
            if (this.vault.attributes() == this) {
                log.debug(String.format("Skip serializing vault attribute %s to avoid recursion", this.vault));
            } else {
                dict.setObjectForKey(this.vault, "Vault");
            }
        }
        if (!this.custom.isEmpty()) {
            dict.setMapForKey(this.custom, "Custom");
        }
        return dict.getSerialized();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public PathAttributes withSize(long size) {
        this.setSize(size);
        return this;
    }

    public long getQuota() {
        return this.quota;
    }

    public void setQuota(long quota) {
        this.quota = quota;
    }

    public PathAttributes withQuota(long quota) {
        this.setQuota(quota);
        return this;
    }

    @Override
    public long getModificationDate() {
        return this.modified;
    }

    public void setModificationDate(long millis) {
        this.modified = millis;
    }

    public PathAttributes withModificationDate(long millis) {
        this.setModificationDate(millis);
        return this;
    }

    @Override
    public long getCreationDate() {
        return this.created;
    }

    public void setCreationDate(long millis) {
        this.created = millis;
    }

    @Override
    public long getAccessedDate() {
        return this.accessed;
    }

    public void setAccessedDate(long millis) {
        this.accessed = millis;
    }

    @Override
    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission p) {
        this.permission = p;
    }

    public PathAttributes withPermission(Permission p) {
        this.setPermission(p);
        return this;
    }

    public Acl getAcl() {
        return this.acl;
    }

    public void setAcl(Acl acl) {
        this.acl = acl;
    }

    public PathAttributes withAcl(Acl acl) {
        this.setAcl(acl);
        return this;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String o) {
        this.owner = o;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String g) {
        this.group = g;
    }

    @Override
    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    public PathAttributes withChecksum(Checksum checksum) {
        this.setChecksum(checksum);
        return this;
    }

    public String getETag() {
        return this.etag;
    }

    public void setETag(String etag) {
        this.etag = etag;
    }

    public PathAttributes withETag(String etag) {
        this.setETag(etag);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public Encryption.Algorithm getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption.Algorithm encryption) {
        this.encryption = encryption;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public PathAttributes withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public PathAttributes withFileId(String fileId) {
        this.setFileId(fileId);
        return this;
    }

    public String getLockId() {
        return this.lockId;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public PathAttributes withLockId(String lockId) {
        this.setLockId(lockId);
        return this;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public Path getDecrypted() {
        return this.decrypted;
    }

    public void setDecrypted(Path decrypted) {
        this.decrypted = decrypted;
    }

    public Path getEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(Path encrypted) {
        this.encrypted = encrypted;
    }

    public void setVault(Path vault) {
        this.vault = vault;
    }

    public Path getVault() {
        return this.vault;
    }

    public boolean isDuplicate() {
        return this.duplicate != null && this.duplicate != false;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public Boolean isHidden() {
        return this.hidden != null && this.hidden != false;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public DescriptiveUrl getLink() {
        return this.link;
    }

    public void setLink(DescriptiveUrl link) {
        this.link = link;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, String> custom) {
        this.custom = custom;
    }

    public PathAttributes withCustom(String key, String value) {
        this.custom = new HashMap<String, String>(this.custom);
        this.custom.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathAttributes)) {
            return false;
        }
        PathAttributes that = (PathAttributes)o;
        if (this.modified != that.modified) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (!Objects.equals(this.checksum, that.checksum)) {
            return false;
        }
        if (!Objects.equals(this.permission, that.permission)) {
            return false;
        }
        if (!Objects.equals(this.acl, that.acl)) {
            return false;
        }
        if (!Objects.equals(this.versionId, that.versionId)) {
            return false;
        }
        if (!Objects.equals(this.fileId, that.fileId)) {
            return false;
        }
        if (!Objects.equals(this.revision, that.revision)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        return Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        int result = (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.modified ^ this.modified >>> 32);
        result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
        result = 31 * result + (this.acl != null ? this.acl.hashCode() : 0);
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
        result = 31 * result + (this.fileId != null ? this.fileId.hashCode() : 0);
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PathAttributes{");
        sb.append("accessed=").append(this.accessed);
        sb.append(", size=").append(this.size);
        sb.append(", modified=").append(this.modified);
        sb.append(", created=").append(this.created);
        sb.append(", owner='").append(this.owner).append('\'');
        sb.append(", group='").append(this.group).append('\'');
        sb.append(", permission=").append(this.permission);
        sb.append(", acl=").append(this.acl);
        sb.append(", checksum='").append(this.checksum).append('\'');
        sb.append(", etag='").append(this.etag).append('\'');
        sb.append(", storageClass='").append(this.storageClass).append('\'');
        sb.append(", encryption='").append(this.encryption).append('\'');
        sb.append(", versionId='").append(this.versionId).append('\'');
        sb.append(", fileId='").append(this.fileId).append('\'');
        sb.append(", lockId='").append(this.lockId).append('\'');
        sb.append(", duplicate=").append(this.duplicate);
        sb.append(", hidden=").append(this.hidden);
        sb.append(", revision=").append(this.revision);
        sb.append(", region='").append(this.region).append('\'');
        sb.append(", metadata=").append(this.metadata).append('\'');
        sb.append(", custom=").append(this.custom).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

