/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledPasswordCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.PasswordCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordCallbackFactory
extends Factory<PasswordCallback> {
    private static final Logger log = LogManager.getLogger(PasswordCallbackFactory.class);
    private Constructor<? extends PasswordCallback> constructor;

    protected PasswordCallbackFactory() {
        super("factory.passwordcallback.class");
    }

    public PasswordCallback create(Controller controller) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            }
            if (null == this.constructor) {
                log.warn(String.format("No matching constructor for parameter %s", controller.getClass()));
                return (PasswordCallback)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledPasswordCallback();
        }
    }

    public static PasswordCallback get(Controller c) {
        return new PasswordCallbackFactory().create(c);
    }
}

