/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractFolderHostCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.io.watchservice.WatchServiceFactory;
import ch.cyberduck.core.local.FileWatcher;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorFolderHostCollection
extends AbstractFolderHostCollection {
    private static final Logger log = LogManager.getLogger(MonitorFolderHostCollection.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final FileWatcher monitor = new FileWatcher(WatchServiceFactory.get());

    public MonitorFolderHostCollection(Local f) {
        super(f);
    }

    @Override
    public void load() throws AccessDeniedException {
        super.load();
        if (this.preferences.getBoolean("bookmarks.folder.monitor")) {
            try {
                this.monitor.register(this.folder, FILE_FILTER, this);
            }
            catch (IOException e) {
                throw new LocalAccessDeniedException(String.format("Failure monitoring directory %s", this.folder.getName()), e);
            }
        }
    }

    @Override
    public void fileWritten(Local file) {
        if (this.isLocked()) {
            log.debug(String.format("Skip reading bookmark from %s", file));
        } else {
            try {
                Host bookmark = HostReaderFactory.get().read(file);
                int index = this.indexOf(bookmark);
                if (index != -1 && new HostEditComparator().compare(bookmark, (Host)this.get(index)) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Replace bookmark %s at index %d", bookmark, index));
                    }
                    this.replace(index, bookmark);
                }
            }
            catch (AccessDeniedException e) {
                log.warn(String.format("Failure reading file %s", file));
            }
        }
    }

    @Override
    public void fileDeleted(Local file) {
        if (this.isLocked()) {
            log.debug(String.format("Skip reading bookmark from %s", file));
        } else {
            Host bookmark = this.lookup(FilenameUtils.getBaseName((String)file.getName()));
            if (bookmark != null) {
                log.warn(String.format("Delete bookmark %s", bookmark));
                this.remove(bookmark);
            }
        }
    }

    @Override
    public void fileCreated(Local file) {
        if (this.isLocked()) {
            log.debug(String.format("Skip reading bookmark from %s", file));
        } else {
            try {
                Host bookmark = HostReaderFactory.get().read(file);
                log.warn(String.format("Add bookmark %s", bookmark));
                this.add(bookmark);
            }
            catch (AccessDeniedException e) {
                log.warn(String.format("Failure reading file %s", file));
            }
        }
    }

    private static final class HostEditComparator
    implements Comparator<Host> {
        private HostEditComparator() {
        }

        @Override
        public int compare(Host o1, Host o2) {
            int i = o1.compareTo(o2);
            if (i == 0) {
                if (!StringUtils.equals((CharSequence)o1.getNickname(), (CharSequence)o2.getNickname())) {
                    return StringUtils.compare((String)o1.getNickname(), (String)o2.getNickname());
                }
                if (!StringUtils.equals((CharSequence)o1.getDefaultPath(), (CharSequence)o2.getDefaultPath())) {
                    return StringUtils.compare((String)o1.getDefaultPath(), (String)o2.getDefaultPath());
                }
                if (!o1.getLabels().equals(o2.getLabels())) {
                    return -1;
                }
                return 0;
            }
            return i;
        }
    }
}

