/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public final class LocalFactory
extends Factory<Local> {
    private final Constructor<? extends Local> constructor;

    protected LocalFactory() {
        super("factory.local.class");
        this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{String.class});
    }

    @Override
    protected Local create() {
        return this.create(PreferencesFactory.get().getProperty("local.user.home"));
    }

    protected Local create(String path) {
        try {
            return this.constructor.newInstance(path);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    protected Local create(Local parent, String path) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{parent.getClass(), path.getClass()});
            return (Local)constructor.newInstance(parent, path);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static Local get(Local parent, String name) {
        return new LocalFactory().create(parent, name);
    }

    public static Local get(String parent, String name) {
        return new LocalFactory().create(new LocalFactory().create(parent), name);
    }

    public static Local get(String path) {
        return new LocalFactory().create(path);
    }

    public static Local get() {
        return new LocalFactory().create();
    }
}

