/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostKeyCallbackFactory
extends Factory<HostKeyCallback> {
    private static final Logger log = LogManager.getLogger(HostKeyCallbackFactory.class);
    private Constructor<? extends HostKeyCallback> constructor;

    protected HostKeyCallbackFactory() {
        super("factory.hostkeycallback.class");
    }

    public HostKeyCallback create(Controller c, Protocol protocol) {
        if (Scheme.sftp.equals((Object)protocol.getScheme())) {
            try {
                if (null == this.constructor) {
                    this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{c.getClass()});
                }
                if (null == this.constructor) {
                    log.warn(String.format("No matching constructor for parameter %s", c.getClass()));
                    return (HostKeyCallback)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                return this.constructor.newInstance(c);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error(String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
                return new DisabledHostKeyCallback();
            }
        }
        return new DisabledHostKeyCallback();
    }

    public static HostKeyCallback get(Controller c, Protocol protocol) {
        return new HostKeyCallbackFactory().create(c, protocol);
    }
}

