/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FallbackAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = LogManager.getLogger(FallbackAttributesFinderFeature.class);
    private final AttributesFinder standard;
    private final AttributesFinder fallback;

    public FallbackAttributesFinderFeature(AttributesFinder standard, AttributesFinder fallback) {
        this.standard = standard;
        this.fallback = fallback;
    }

    @Override
    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            return this.standard.find(file, listener);
        }
        catch (AccessDeniedException | InteroperabilityException | NotfoundException f) {
            log.warn(String.format("Failure listing directory %s. %s", file.getParent(), f.getMessage()));
            if (this.fallback instanceof DefaultAttributesFinderFeature) {
                throw f;
            }
            return this.fallback.find(file, listener);
        }
    }
}

