/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisabledConnectionCallback
implements ConnectionCallback {
    private static final Logger log = LogManager.getLogger(DisabledConnectionCallback.class);

    @Override
    public void warn(Host bookmark, String title, String message, String continueButton, String disconnectButton, String preference) throws ConnectionCanceledException {
        log.warn(String.format("Ignore prompt %s for %s", message, bookmark));
    }

    @Override
    public void await(CountDownLatch signal, Host bookmark, String title, String message) throws ConnectionCanceledException {
        throw new LoginCanceledException();
    }

    @Override
    public void close(String input) {
        log.warn(String.format("Ignore close with input %s", input));
    }

    @Override
    public Credentials prompt(Host bookmark, String title, String reason, LoginOptions options) throws LoginCanceledException {
        throw new LoginCanceledException();
    }
}

