/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.LocaleFactory;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DescriptiveUrl {
    public static final DescriptiveUrl EMPTY = new DescriptiveUrl(URI.create(""));
    private final URI url;
    private final Type type;
    private final String help;

    public DescriptiveUrl(URI url) {
        this(url, Type.http, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), StringUtils.upperCase((String)url.getScheme())));
    }

    public DescriptiveUrl(URI url, Type type) {
        this(url, type, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), StringUtils.upperCase((String)url.getScheme())));
    }

    public DescriptiveUrl(URI url, Type type, String help) {
        this.url = url;
        this.type = type;
        this.help = help;
    }

    public DescriptiveUrl(DescriptiveUrl other) {
        this.url = other.url;
        this.type = other.type;
        this.help = other.help;
    }

    public String getUrl() {
        if (null == this.url) {
            return null;
        }
        return this.url.toString();
    }

    public Type getType() {
        return this.type;
    }

    public String getHelp() {
        return this.help;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptiveUrl that = (DescriptiveUrl)o;
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public String toString() {
        return this.getUrl();
    }

    public static enum Type {
        provider,
        http,
        cdn,
        origin,
        cname,
        signed,
        authenticated,
        analytics,
        encrypted;

    }
}

