/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.WebUrlProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class DefaultWebUrlProvider
implements WebUrlProvider {
    @Override
    public DescriptiveUrl toUrl(Host bookmark) {
        URI uri;
        String base;
        if (StringUtils.isBlank((CharSequence)bookmark.getWebURL())) {
            switch (bookmark.getProtocol().getScheme()) {
                case https: {
                    base = String.format("https://%s/", StringUtils.strip((String)bookmark.getHostname()));
                    break;
                }
                default: {
                    base = String.format("http://%s/", StringUtils.strip((String)bookmark.getHostname()));
                    break;
                }
            }
        } else {
            base = bookmark.getWebURL().matches("^http(s)?://.*$") ? bookmark.getWebURL() : String.format("http://%s/", bookmark.getWebURL());
        }
        try {
            uri = new URI(base);
        }
        catch (URISyntaxException e) {
            return DescriptiveUrl.EMPTY;
        }
        return new DescriptiveUrl(uri, DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), StringUtils.upperCase((String)uri.getScheme())));
    }
}

