/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.OAuthTokens;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DefaultHostPasswordStore
implements HostPasswordStore {
    private static final Logger log = LogManager.getLogger(DefaultHostPasswordStore.class);
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public String findLoginPassword(Host bookmark) {
        String password;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn("No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn("No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Fetching login password from keychain for %s", bookmark));
        }
        try {
            password = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername());
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure %s searching in keychain", e));
            return null;
        }
        if (null == password && log.isInfoEnabled()) {
            log.info(String.format("Password not found in keychain for %s", bookmark));
        }
        return password;
    }

    @Override
    public String findLoginToken(Host bookmark) {
        String token;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn("No hostname given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Fetching login token from keychain for %s", bookmark));
        }
        Credentials credentials = bookmark.getCredentials();
        try {
            token = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), StringUtils.isEmpty((CharSequence)credentials.getUsername()) ? bookmark.getProtocol().getTokenPlaceholder() : String.format("%s (%s)", bookmark.getProtocol().getTokenPlaceholder(), credentials.getUsername()));
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure %s searching in keychain", e));
            return null;
        }
        if (null == token && log.isInfoEnabled()) {
            log.info(String.format("Token not found in keychain for %s", bookmark));
        }
        return token;
    }

    @Override
    public String findPrivateKeyPassphrase(Host bookmark) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn("No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn("No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Fetching private key passphrase from keychain for %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            Local key = credentials.getIdentity();
            try {
                String passphrase = this.getPassword(bookmark.getHostname(), key.getAbbreviatedPath());
                if (null == passphrase) {
                    passphrase = this.getPassword("SSH", key.getAbsolute());
                }
                if (null == passphrase) {
                    passphrase = this.getPassword("SSHKeychain", key.getAbbreviatedPath());
                }
                if (null == passphrase && log.isInfoEnabled()) {
                    log.info(String.format("Passphrase not found in keychain for %s", key));
                }
                return passphrase;
            }
            catch (LocalAccessDeniedException e) {
                log.warn(String.format("Failure %s searching in keychain", e));
                return null;
            }
        }
        return null;
    }

    @Override
    public OAuthTokens findOAuthTokens(Host bookmark) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Fetching OAuth tokens from keychain for %s", bookmark));
        }
        long expiry = this.preferences.getLong(String.format("%s.oauth.expiry", bookmark.getProtocol().getIdentifier()));
        String prefix = this.getOAuthPrefix(bookmark);
        String hostname = this.getOAuthHostname(bookmark);
        try {
            return new OAuthTokens(this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), hostname, String.format("%s OAuth2 Access Token", prefix)), this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), hostname, String.format("%s OAuth2 Refresh Token", prefix)), expiry);
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure %s searching in keychain", e));
            return OAuthTokens.EMPTY;
        }
    }

    protected String getOAuthHostname(Host bookmark) {
        if (StringUtils.isNotBlank((CharSequence)URI.create(bookmark.getProtocol().getOAuthTokenUrl()).getHost())) {
            return URI.create(bookmark.getProtocol().getOAuthTokenUrl()).getHost();
        }
        return bookmark.getHostname();
    }

    private String getOAuthPrefix(Host bookmark) {
        if (StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername())) {
            return String.format("%s (%s)", bookmark.getProtocol().getDescription(), bookmark.getCredentials().getUsername());
        }
        return bookmark.getProtocol().getDescription();
    }

    @Override
    public void save(Host bookmark) throws LocalAccessDeniedException {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn("No hostname given");
            return;
        }
        Credentials credentials = bookmark.getCredentials();
        if (log.isInfoEnabled()) {
            log.info(String.format("Save credentials for bookmark %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            this.addPassword(bookmark.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getIdentityPassphrase());
        }
        if (credentials.isPasswordAuthentication()) {
            if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
                log.warn(String.format("No username in credentials for bookmark %s", bookmark.getHostname()));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)credentials.getPassword())) {
                log.warn(String.format("No password in credentials for bookmark %s", bookmark.getHostname()));
                return;
            }
            this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername(), credentials.getPassword());
        }
        if (credentials.isTokenAuthentication()) {
            this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), StringUtils.isEmpty((CharSequence)credentials.getUsername()) ? bookmark.getProtocol().getTokenPlaceholder() : String.format("%s (%s)", bookmark.getProtocol().getTokenPlaceholder(), credentials.getUsername()), credentials.getToken());
        }
        if (credentials.isOAuthAuthentication()) {
            String prefix = this.getOAuthPrefix(bookmark);
            if (StringUtils.isNotBlank((CharSequence)credentials.getOauth().getAccessToken())) {
                this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), this.getOAuthHostname(bookmark), String.format("%s OAuth2 Access Token", prefix), credentials.getOauth().getAccessToken());
            }
            if (StringUtils.isNotBlank((CharSequence)credentials.getOauth().getRefreshToken())) {
                this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), this.getOAuthHostname(bookmark), String.format("%s OAuth2 Refresh Token", prefix), credentials.getOauth().getRefreshToken());
            }
            if (credentials.getOauth().getExpiryInMilliseconds() != null) {
                this.preferences.setProperty(String.format("%s.oauth.expiry", bookmark.getProtocol().getIdentifier()), credentials.getOauth().getExpiryInMilliseconds());
            }
        }
    }

    @Override
    public void delete(Host bookmark) throws LocalAccessDeniedException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Delete password for bookmark %s", bookmark));
        }
        Credentials credentials = bookmark.getCredentials();
        Protocol protocol = bookmark.getProtocol();
        if (protocol.isPrivateKeyConfigurable()) {
            this.deletePassword(bookmark.getHostname(), credentials.getIdentity().getAbbreviatedPath());
        }
        if (protocol.isPasswordConfigurable()) {
            if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
                log.warn(String.format("No username in credentials for bookmark %s", bookmark.getHostname()));
                return;
            }
            this.deletePassword(protocol.getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername());
        }
        if (protocol.isTokenConfigurable()) {
            this.deletePassword(protocol.getScheme(), bookmark.getPort(), bookmark.getHostname(), StringUtils.isEmpty((CharSequence)credentials.getUsername()) ? protocol.getTokenPlaceholder() : String.format("%s (%s)", protocol.getTokenPlaceholder(), credentials.getUsername()));
        }
        if (protocol.isOAuthConfigurable()) {
            String prefix = this.getOAuthPrefix(bookmark);
            if (StringUtils.isNotBlank((CharSequence)credentials.getOauth().getAccessToken())) {
                this.deletePassword(protocol.getScheme(), bookmark.getPort(), this.getOAuthHostname(bookmark), String.format("%s OAuth2 Access Token", prefix));
            }
            if (StringUtils.isNotBlank((CharSequence)credentials.getOauth().getRefreshToken())) {
                this.deletePassword(protocol.getScheme(), bookmark.getPort(), this.getOAuthHostname(bookmark), String.format("%s OAuth2 Refresh Token", prefix));
            }
            if (credentials.getOauth().getExpiryInMilliseconds() != null) {
                this.preferences.setProperty(String.format("%s.oauth.expiry", protocol.getIdentifier()), credentials.getOauth().getExpiryInMilliseconds());
            }
        }
    }
}

