/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.ConnectionTimeout;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.PreferencesReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConnectionTimeout
implements ConnectionTimeout {
    private static final Logger log = LogManager.getLogger(DefaultConnectionTimeout.class);
    private static final Preferences mutablePreferences = PreferencesFactory.get();
    public static final int TIMEOUT_MIN = 10;
    public static final int TIMEOUT_MAX = 60;
    private final PreferencesReader preferences;

    public DefaultConnectionTimeout() {
        this(mutablePreferences);
    }

    public DefaultConnectionTimeout(PreferencesReader preferences) {
        this.preferences = preferences;
    }

    @Override
    public int getTimeout() {
        return DefaultConnectionTimeout.clamp(this.preferences.getInteger("connection.timeout.seconds"));
    }

    @Override
    public void setTimeout(int timeout) {
        mutablePreferences.setProperty("connection.timeout.seconds", DefaultConnectionTimeout.clamp(timeout));
    }

    private static int clamp(int value) {
        if (value < 10) {
            value = 10;
        }
        if (value > 60) {
            value = 60;
        }
        return value;
    }
}

