/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.CertificateTrustCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.ssl.CertificateStoreX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;

public class DefaultCertificateStore
implements CertificateStore {
    private final DefaultHostnameVerifier verifier = new DefaultHostnameVerifier();

    @Override
    public X509Certificate choose(CertificateIdentityCallback prompt, String[] keyTypes, Principal[] issuers, Host bookmark) throws ConnectionCanceledException {
        CertificateStoreX509KeyManager store = new KeychainX509KeyManager(prompt, bookmark, this).init();
        String[] aliases = store.getClientAliases(keyTypes, issuers);
        if (null == aliases) {
            throw new ConnectionCanceledException(String.format("No certificate matching issuer %s found", Arrays.toString(issuers)));
        }
        int n = 0;
        String[] stringArray = aliases;
        int n2 = stringArray.length;
        if (n < n2) {
            String alias = stringArray[n];
            return store.getCertificate(alias, keyTypes, issuers);
        }
        return null;
    }

    @Override
    public boolean verify(CertificateTrustCallback prompt, String hostname, List<X509Certificate> certificates) {
        if (certificates.isEmpty()) {
            return false;
        }
        for (X509Certificate c : certificates) {
            try {
                c.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                return false;
            }
        }
        try {
            this.verifier.verify(hostname, certificates.get(0));
        }
        catch (SSLException e) {
            return false;
        }
        return true;
    }
}

