/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.ConnectionTimeout;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionTimeoutFactory
extends Factory<ConnectionTimeout> {
    private static final Logger log = LogManager.getLogger(ConnectionTimeoutFactory.class);
    private static final ConnectionTimeoutFactory factory = new ConnectionTimeoutFactory();
    private final ConnectionTimeout instance = (ConnectionTimeout)this.create();
    private final Constructor<? extends ConnectionTimeout> constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{PreferencesReader.class});

    private ConnectionTimeoutFactory() {
        super("factory.connectiontimeout.class");
    }

    public ConnectionTimeout create(PreferencesReader preferences) {
        ConnectionTimeout temp = this.instance;
        if (this.constructor != null) {
            try {
                temp = this.constructor.newInstance(preferences);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                log.error(String.format("Failure loading host connection timeout class %s. %s", this.clazz, e.getMessage()));
            }
        }
        return temp;
    }

    public static ConnectionTimeout get() {
        return ConnectionTimeoutFactory.factory.instance;
    }

    public static ConnectionTimeout get(Host host) {
        return ConnectionTimeoutFactory.get(new HostPreferences(host));
    }

    public static ConnectionTimeout get(PreferencesReader preferences) {
        return factory.create(preferences);
    }
}

