/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CertificateTrustCallback;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledCertificateTrustCallback;
import ch.cyberduck.core.Factory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateTrustCallbackFactory
extends Factory<CertificateTrustCallback> {
    private static final Logger log = LogManager.getLogger(CertificateTrustCallbackFactory.class);
    private Constructor<? extends CertificateTrustCallback> constructor;

    protected CertificateTrustCallbackFactory() {
        super("factory.certificatetrustcallback.class");
    }

    public CertificateTrustCallback create(Controller controller) {
        try {
            if (null == this.constructor) {
                this.constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{controller.getClass()});
            }
            if (null == this.constructor) {
                log.warn(String.format("No matching constructor for parameter %s", controller.getClass()));
                return (CertificateTrustCallback)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return this.constructor.newInstance(controller);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error(String.format("Failure loading callback class %s. %s", this.clazz, e.getMessage()));
            return new DisabledCertificateTrustCallback();
        }
    }

    public static CertificateTrustCallback get(Controller c) {
        return new CertificateTrustCallbackFactory().create(c);
    }
}

