/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CaseInsensitivePathPredicate;
import ch.cyberduck.core.CaseSensitivePathPredicate;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CachingVersionIdProvider
implements VersionIdProvider {
    private static final Logger log = LogManager.getLogger(CachingVersionIdProvider.class);
    private final LRUCache<SimplePathPredicate, String> cache = LRUCache.build(PreferencesFactory.get().getLong("fileid.cache.size"));
    private final Protocol.Case sensitivity;

    protected CachingVersionIdProvider(Protocol.Case sensitivity) {
        this.sensitivity = sensitivity;
    }

    @Override
    public String getVersionId(Path file, ListProgressListener listener) throws BackgroundException {
        return this.cache.get(this.toPredicate(file));
    }

    private SimplePathPredicate toPredicate(Path file) {
        return this.sensitivity == Protocol.Case.sensitive ? new CaseSensitivePathPredicate(file) : new CaseInsensitivePathPredicate(file);
    }

    public String cache(Path file, String id) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Cache %s for file %s", id, file));
        }
        if (null == id) {
            this.cache.remove(this.toPredicate(file));
            file.attributes().setVersionId(null);
            if (file.isDirectory()) {
                for (SimplePathPredicate entry : this.cache.asMap().keySet()) {
                    if (!entry.isChild(this.toPredicate(file))) continue;
                    this.cache.remove(entry);
                }
            }
        } else {
            if (file.attributes().isDuplicate()) {
                log.warn(String.format("Skip caching for previous version %s", file));
                return id;
            }
            this.cache.put(this.toPredicate(file), id);
            file.attributes().setVersionId(id);
        }
        return id;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

