/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingListProgressListener
extends DisabledListProgressListener {
    private static final Logger log = LogManager.getLogger(CachingListProgressListener.class);
    private final Cache<Path> cache;
    private final Map<Path, AttributedList<Path>> contents = new HashMap<Path, AttributedList<Path>>(1);

    public CachingListProgressListener(Cache<Path> cache) {
        this.cache = cache;
    }

    @Override
    public void chunk(Path folder, AttributedList<Path> list) {
        this.contents.put(folder, list);
    }

    public void cache() {
        for (Map.Entry<Path, AttributedList<Path>> entry : this.contents.entrySet()) {
            AttributedList<Path> list = entry.getValue();
            if (AttributedList.emptyList() == list) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Cache directory listing for %s", entry.getKey()));
            }
            this.cache.put(entry.getKey(), list);
        }
    }
}

