/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProxyListProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.shared.ListFilteringFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingFindFeature
implements Find {
    private static final Logger log = LogManager.getLogger(CachingFindFeature.class);
    private final Cache<Path> cache;
    private final Find delegate;

    public CachingFindFeature(Cache<Path> cache, Find delegate) {
        this.cache = cache;
        this.delegate = delegate;
    }

    @Override
    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return this.delegate.find(file, listener);
        }
        if (this.cache.isValid(file.getParent())) {
            AttributedList<Path> list = this.cache.get(file.getParent());
            Path found = list.find(new ListFilteringFeature.ListFilteringPredicate(Protocol.Case.sensitive, file));
            if (found != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found %s in cache", file));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Cached directory listing does not contain %s", file));
            }
            return false;
        }
        CachingListProgressListener caching = new CachingListProgressListener(this.cache);
        boolean found = this.delegate.find(file, new ProxyListProgressListener(listener, caching));
        caching.cache();
        return found;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CachingFindFeature{");
        sb.append("cache=").append(this.cache);
        sb.append(", delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

