/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProxyListProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.shared.ListFilteringFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = LogManager.getLogger(CachingAttributesFinderFeature.class);
    private final Cache<Path> cache;
    private final AttributesFinder delegate;

    public CachingAttributesFinderFeature(Cache<Path> cache, AttributesFinder delegate) {
        this.cache = cache;
        this.delegate = delegate;
    }

    @Override
    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return this.delegate.find(file, listener);
        }
        if (this.cache.isValid(file.getParent())) {
            AttributedList<Path> list = this.cache.get(file.getParent());
            Path found = list.find(new ListFilteringFeature.ListFilteringPredicate(Protocol.Case.sensitive, file));
            if (null != found) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return cached attributes %s for %s", found.attributes(), file));
                }
                return found.attributes();
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Cached directory listing does not contain %s", file));
            }
            throw new NotfoundException(file.getAbsolute());
        }
        CachingListProgressListener caching = new CachingListProgressListener(this.cache);
        try {
            PathAttributes attr = this.delegate.find(file, new ProxyListProgressListener(listener, caching));
            caching.cache();
            return attr;
        }
        catch (NotfoundException e) {
            caching.cache();
            throw e;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CachingAttributesFinderFeature{");
        sb.append("cache=").append(this.cache);
        sb.append(", delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

