/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.MonitorFolderHostCollection;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.Comparator;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BookmarkCollection
extends MonitorFolderHostCollection {
    private static final Logger log = LogManager.getLogger(BookmarkCollection.class);
    private final Preferences preferences = PreferencesFactory.get();
    private static final BookmarkCollection FAVORITES_COLLECTION = new BookmarkCollection(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "Bookmarks")){

        @Override
        public void collectionItemAdded(Host bookmark) {
            bookmark.setWorkdir(null);
            super.collectionItemAdded(bookmark);
        }
    };
    private static final String DEFAULT_PREFIX = "bookmark";
    private final String prefix;

    private static String toProperty(Host bookmark, String prefix) {
        return String.format("%s%s", prefix, bookmark.getUuid());
    }

    public static BookmarkCollection defaultCollection() {
        return FAVORITES_COLLECTION;
    }

    public BookmarkCollection(Local f) {
        this(f, DEFAULT_PREFIX);
    }

    public BookmarkCollection(Local f, String prefix) {
        super(f);
        this.prefix = String.format("%s.", prefix);
    }

    @Override
    public void collectionItemAdded(Host bookmark) {
        try {
            if (this.isLocked()) {
                log.debug("Skip indexing collection while loading");
            } else {
                this.index();
            }
        }
        finally {
            super.collectionItemAdded(bookmark);
        }
    }

    @Override
    public void collectionItemRemoved(Host bookmark) {
        try {
            if (this.isLocked()) {
                log.debug("Skip indexing collection while loading");
            } else {
                this.preferences.deleteProperty(BookmarkCollection.toProperty(bookmark, this.prefix));
            }
        }
        finally {
            super.collectionItemRemoved(bookmark);
        }
    }

    private void index() {
        IntStream.range(0, this.size()).forEach((int i) -> this.preferences.setProperty(BookmarkCollection.toProperty((Host)this.get(i), this.prefix), i));
    }

    @Override
    public void save() {
        try {
            this.index();
        }
        finally {
            super.save();
        }
    }

    @Override
    public void sort() {
        this.sort((Comparator<? super Host>)new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return Integer.compare(BookmarkCollection.this.preferences.getInteger(BookmarkCollection.toProperty(o1, BookmarkCollection.this.prefix)), BookmarkCollection.this.preferences.getInteger(BookmarkCollection.toProperty(o2, BookmarkCollection.this.prefix)));
            }
        });
    }
}

