/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.threading.CancelCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnonymousConnectionService
implements ConnectionService {
    private static final Logger log = LogManager.getLogger(AnonymousConnectionService.class);

    @Override
    public boolean check(Session<?> session, CancelCallback callback) throws BackgroundException {
        if (session.isConnected()) {
            return false;
        }
        this.connect(session, callback);
        return true;
    }

    @Override
    public void connect(Session<?> session, CancelCallback cancel) throws BackgroundException {
        session.open(ProxyFactory.get().find(session.getHost().getHostname()), new DisabledHostKeyCallback(), new DisabledLoginCallback(), cancel);
    }

    @Override
    public void close(Session<?> session) throws BackgroundException {
        session.close();
    }
}

