/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Acl
extends HashMap<User, Set<Role>>
implements Serializable {
    private static final Logger log = LogManager.getLogger(Acl.class);
    public static final Acl EMPTY = new Acl(new UserAndRole[0]);
    public static final Acl CANNED_PRIVATE = new Acl("private");
    public static final Acl CANNED_PUBLIC_READ = new Acl("public-read");
    public static final Acl CANNED_PUBLIC_READ_WRITE = new Acl("public-read-write");
    public static final Acl CANNED_AUTHENTICATED_READ = new Acl("authenticated-read");
    public static final Acl CANNED_BUCKET_OWNER_FULLCONTROL = new Acl("bucket-owner-full-control");
    public static final Acl CANNED_BUCKET_OWNER_READ = new Acl("bucket-owner-read");
    private final String canned;
    private boolean editable = true;

    public static Acl toAcl(String identifier) {
        if (CANNED_PRIVATE.getCannedString().equals(identifier)) {
            return CANNED_PRIVATE;
        }
        if (CANNED_PUBLIC_READ.getCannedString().equals(identifier)) {
            return CANNED_PUBLIC_READ;
        }
        if (CANNED_PUBLIC_READ_WRITE.getCannedString().equals(identifier)) {
            return CANNED_PUBLIC_READ_WRITE;
        }
        if (CANNED_AUTHENTICATED_READ.getCannedString().equals(identifier)) {
            return CANNED_AUTHENTICATED_READ;
        }
        if (CANNED_BUCKET_OWNER_FULLCONTROL.getCannedString().equals(identifier)) {
            return CANNED_BUCKET_OWNER_FULLCONTROL;
        }
        if (CANNED_BUCKET_OWNER_READ.getCannedString().equals(identifier)) {
            return CANNED_BUCKET_OWNER_READ;
        }
        log.warn(String.format("Unknown canned ACL identifier %s", identifier));
        return EMPTY;
    }

    public Acl(String canned) {
        this.canned = canned;
    }

    public Acl(User user, Role ... permissions) {
        this.addAll(user, permissions);
        this.canned = "";
    }

    public Acl(UserAndRole ... set) {
        this.addAll(set);
        this.canned = "";
    }

    public Acl(Acl other) {
        this.putAll(other);
        this.canned = other.canned;
        this.editable = other.editable;
    }

    public boolean isCanned() {
        return CANNED_PRIVATE.equals(this) || CANNED_PUBLIC_READ_WRITE.equals(this) || CANNED_PUBLIC_READ.equals(this) || CANNED_AUTHENTICATED_READ.equals(this) || CANNED_BUCKET_OWNER_FULLCONTROL.equals(this) || CANNED_BUCKET_OWNER_READ.equals(this);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getCannedString() {
        return this.canned;
    }

    public void addAll(User user, Role ... permissions) {
        if (this.containsKey(user)) {
            ((Set)this.get(user)).addAll(Arrays.asList(permissions));
        } else {
            this.put(user, new HashSet<Role>(Arrays.asList(permissions)));
        }
    }

    public void addAll(UserAndRole ... set) {
        for (UserAndRole userAndRole : set) {
            this.addAll(userAndRole.getUser(), userAndRole.getRole());
        }
    }

    public List<UserAndRole> asList() {
        ArrayList<UserAndRole> grants = new ArrayList<UserAndRole>();
        for (Map.Entry user : this.entrySet()) {
            for (Role role : (Set)user.getValue()) {
                grants.add(new UserAndRole((User)user.getKey(), role));
            }
        }
        Collections.sort(grants);
        return grants;
    }

    public boolean isModified() {
        for (UserAndRole ua : this.asList()) {
            if (ua.getUser().isModified()) {
                return true;
            }
            if (!ua.getRole().isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T serialize(Serializer<T> dict) {
        for (Map.Entry entry : this.entrySet()) {
            ArrayList roles = new ArrayList((Collection)entry.getValue());
            dict.setListForKey(roles, ((User)entry.getKey()).getIdentifier());
        }
        return dict.getSerialized();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Acl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Acl acl = (Acl)o;
        return Objects.equals(this.canned, acl.canned);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.canned);
    }

    public static abstract class User
    implements Comparable<User> {
        private String identifier;
        private final boolean editable;
        private boolean modified;

        public User(String identifier) {
            this(identifier, true);
        }

        public User(String identifier, boolean editable) {
            this.identifier = identifier;
            this.editable = editable;
        }

        public abstract String getPlaceholder();

        public String toString() {
            return this.identifier;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String getDisplayName() {
            return LocaleFactory.localizedString(this.getIdentifier(), "S3");
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
            this.modified = true;
        }

        public boolean isValid() {
            return StringUtils.isNotBlank((CharSequence)this.getIdentifier());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return Objects.equals(this.identifier, user.identifier);
        }

        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        @Override
        public int compareTo(User o) {
            return this.identifier.compareTo(o.identifier);
        }

        public boolean isModified() {
            return this.modified;
        }
    }

    public static class Role
    implements Comparable<Role>,
    Serializable {
        public static final String FULL = "FULL_CONTROL";
        public static final String READ = "READ";
        public static final String WRITE = "WRITE";
        private String name;
        private final boolean editable;
        private boolean modified;

        public Role(String name) {
            this(name, true);
        }

        public Role(String name, boolean editable) {
            this.name = name;
            this.editable = editable;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return LocaleFactory.localizedString(this.getName(), "S3");
        }

        public void setName(String name) {
            this.name = name;
            this.modified = true;
        }

        public boolean isValid() {
            return StringUtils.isNotBlank((CharSequence)this.getName());
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Role)) {
                return false;
            }
            Role role = (Role)o;
            return Objects.equals(this.name, role.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        @Override
        public int compareTo(Role o) {
            return this.name.compareTo(o.name);
        }

        public boolean isModified() {
            return this.modified;
        }

        @Override
        public <T> T serialize(Serializer<T> dict) {
            dict.setStringForKey(this.name, "Name");
            return dict.getSerialized();
        }
    }

    public static class UserAndRole
    implements Comparable<UserAndRole> {
        private final User user;
        private final Role role;

        public UserAndRole(User user, Role role) {
            this.user = user;
            this.role = role;
        }

        public User getUser() {
            return this.user;
        }

        public Role getRole() {
            return this.role;
        }

        public boolean isValid() {
            return this.user.isValid() && this.role.isValid();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UserAndRole)) {
                return false;
            }
            UserAndRole that = (UserAndRole)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.role, that.role);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.role);
        }

        public String toString() {
            return String.format("%s:%s", this.user.toString(), this.role.toString());
        }

        @Override
        public int compareTo(UserAndRole o) {
            return this.toString().compareTo(o.toString());
        }
    }

    public static class RoleDictionary<T> {
        private final DeserializerFactory<T> deserializer;

        public RoleDictionary() {
            this.deserializer = new DeserializerFactory();
        }

        public RoleDictionary(DeserializerFactory<T> deserializer) {
            this.deserializer = deserializer;
        }

        public Role deserialize(T serialized) {
            Deserializer<T> dict = this.deserializer.create(serialized);
            return new Role(dict.stringForKey("Name"));
        }
    }

    public static class Owner
    extends CanonicalUser {
        public Owner(String identifier) {
            super(identifier);
        }

        public Owner(String identifier, String displayName) {
            super(identifier, displayName, false);
        }

        @Override
        public String getPlaceholder() {
            return LocaleFactory.localizedString("Owner");
        }

        @Override
        public String getDisplayName() {
            return LocaleFactory.localizedString("Owner");
        }
    }

    public static class DomainUser
    extends User {
        public DomainUser(String identifier) {
            super(identifier, true);
        }

        @Override
        public String getPlaceholder() {
            return LocaleFactory.localizedString("Domain Name", "S3");
        }
    }

    public static class EmailGroupUser
    extends User {
        public EmailGroupUser(String identifier) {
            this(identifier, false);
        }

        public EmailGroupUser(String identifier, boolean editable) {
            super(identifier, editable);
        }

        @Override
        public String getPlaceholder() {
            return LocaleFactory.localizedString("Email Address", "S3");
        }
    }

    public static class GroupUser
    extends User {
        public static final String EVERYONE = "AllUsers";
        public static final String AUTHENTICATED = "AllAuthenticatedUsers";

        public GroupUser(String identifier) {
            this(identifier, false);
        }

        public GroupUser(String identifier, boolean editable) {
            super(identifier, editable);
        }

        @Override
        public String getPlaceholder() {
            return LocaleFactory.localizedString(this.getIdentifier(), "S3");
        }
    }

    public static class EmailUser
    extends CanonicalUser {
        public EmailUser() {
            super("", true);
        }

        public EmailUser(String identifier) {
            super(identifier, true);
        }

        public EmailUser(String identifier, boolean editable) {
            super(identifier, editable);
        }

        public EmailUser(String identifier, String displayName, boolean editable) {
            super(identifier, displayName, editable);
        }

        @Override
        public String getPlaceholder() {
            return LocaleFactory.localizedString("Email Address", "S3");
        }
    }

    public static class CanonicalUser
    extends User {
        private String displayName;

        public CanonicalUser() {
            this("", null);
        }

        public CanonicalUser(String identifier) {
            this(identifier, null);
        }

        public CanonicalUser(String identifier, boolean editable) {
            this(identifier, null, editable);
        }

        public CanonicalUser(String identifier, String displayName) {
            this(identifier, displayName, true);
        }

        public CanonicalUser(String identifier, String displayName, boolean editable) {
            super(identifier, editable);
            this.displayName = displayName;
        }

        @Override
        public String getPlaceholder() {
            return LocaleFactory.localizedString("Canonical User ID", "S3");
        }

        @Override
        public String getDisplayName() {
            if (StringUtils.isEmpty((CharSequence)this.displayName)) {
                return super.getDisplayName();
            }
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String toString() {
            if (StringUtils.isNotBlank((CharSequence)this.displayName)) {
                return String.format("%s (%s)", this.displayName, this.getIdentifier());
            }
            return super.toString();
        }
    }
}

