/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.EditableCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import ch.cyberduck.core.HostGroups;
import ch.cyberduck.core.text.DefaultLexicographicOrderComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractHostCollection
extends Collection<Host>
implements EditableCollection {
    private static final Logger log = LogManager.getLogger(AbstractHostCollection.class);
    private static final AbstractHostCollection EMPTY = new AbstractHostCollection(){};

    public static AbstractHostCollection empty() {
        return EMPTY;
    }

    public AbstractHostCollection() {
    }

    public AbstractHostCollection(java.util.Collection<Host> c) {
        super(c);
    }

    public void sort() {
        this.sort(new Comparator<Host>(){

            @Override
            public int compare(Host o1, Host o2) {
                return new DefaultLexicographicOrderComparator().compare(BookmarkNameProvider.toString(o1), BookmarkNameProvider.toString(o2));
            }
        });
    }

    public Map<String, List<Host>> groups() {
        return this.groups(HostFilter.NONE);
    }

    public Map<String, List<Host>> groups(HostFilter filter) {
        return this.groups(Host::getLabels, filter);
    }

    public Map<String, List<Host>> groups(HostGroups groups, HostFilter filter) {
        HashMap<String, List<Host>> labels = new HashMap<String, List<Host>>();
        for (Host host : this.stream().filter(filter::accept).collect(Collectors.toList())) {
            if (groups.groups(host).isEmpty()) {
                List list = labels.getOrDefault("", new ArrayList());
                list.add(host);
                labels.put("", list);
                continue;
            }
            for (String label : groups.groups(host)) {
                List list = labels.getOrDefault(label, new ArrayList());
                list.add(host);
                labels.put(label, list);
            }
        }
        return labels;
    }

    @Override
    public boolean allowsAdd() {
        return true;
    }

    @Override
    public boolean allowsDelete() {
        return true;
    }

    @Override
    public boolean allowsEdit() {
        return true;
    }

    public Optional<Host> find(Host input) {
        return Optional.ofNullable(this.find(new HostComparePredicate(input)).orElse(this.find(new DefaultPathPredicate(input)).orElse(this.find(new ProfilePredicate(input)).orElse(this.find(new ProtocolIdentifierPredicate(input)).orElse(null)))));
    }

    public Optional<Host> find(Predicate<Host> predicate) {
        return this.stream().filter(predicate).findAny();
    }

    public Host lookup(String uuid) {
        return this.stream().filter(h -> h.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    public String getComment(Host h) {
        if (StringUtils.isNotBlank((CharSequence)h.getComment())) {
            return StringUtils.remove((String)StringUtils.remove((String)h.getComment(), (char)'\n'), (char)'\r');
        }
        return null;
    }

    public static final class HostComparePredicate
    implements Predicate<Host> {
        private final Host input;

        public HostComparePredicate(Host input) {
            this.input = input;
        }

        @Override
        public boolean test(Host h) {
            return h.compareTo(this.input) == 0;
        }
    }

    public static final class DefaultPathPredicate
    extends HostnamePredicate {
        private final Host input;

        private DefaultPathPredicate(Host input) {
            super(input);
            this.input = input;
        }

        @Override
        public boolean test(Host h) {
            return super.test(h) && StringUtils.isNotBlank((CharSequence)this.input.getDefaultPath()) && StringUtils.startsWith((CharSequence)this.input.getDefaultPath(), (CharSequence)h.getDefaultPath());
        }
    }

    public static final class ProfilePredicate
    extends HostnamePredicate {
        private final Host input;

        private ProfilePredicate(Host input) {
            super(input);
            this.input = input;
        }

        @Override
        public boolean test(Host h) {
            return super.test(h) && Objects.equals(h.getProtocol(), this.input.getProtocol());
        }
    }

    public static final class ProtocolIdentifierPredicate
    extends HostnamePredicate {
        private final Host input;

        private ProtocolIdentifierPredicate(Host input) {
            super(input);
            this.input = input;
        }

        @Override
        public boolean test(Host h) {
            return super.test(h) && Objects.equals(h.getProtocol().getIdentifier(), this.input.getProtocol().getIdentifier());
        }
    }

    public static class HostnamePredicate
    implements Predicate<Host> {
        private final Host input;

        private HostnamePredicate(Host input) {
            this.input = input;
        }

        @Override
        public boolean test(Host h) {
            if (StringUtils.isNotBlank((CharSequence)this.input.getCredentials().getUsername()) && !Objects.equals(h.getCredentials().getUsername(), this.input.getCredentials().getUsername())) {
                return false;
            }
            return Objects.equals(h.getHostname(), this.input.getHostname());
        }
    }
}

