/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.DefaultBackgroundExecutor;
import ch.cyberduck.core.threading.MainAction;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractController
implements Controller {
    private static final Logger log = LogManager.getLogger(AbstractController.class);
    protected final BackgroundActionRegistry registry = new BackgroundActionRegistry();

    @Override
    public void invoke(MainAction runnable) {
        this.invoke(runnable, false);
    }

    @Override
    public BackgroundActionRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public <T> Future<T> background(BackgroundAction<T> action) {
        if (this.registry.contains(action)) {
            log.warn(String.format("Skip duplicate background action %s found in registry", action));
            return ConcurrentUtils.constantFuture(null);
        }
        return DefaultBackgroundExecutor.get().execute(this, this.registry, action);
    }

    protected void invalidate() {
    }

    @Override
    public void start(BackgroundAction action) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Start action %s", action));
        }
    }

    @Override
    public void cancel(BackgroundAction action) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Cancel action %s", action));
        }
    }

    @Override
    public void stop(BackgroundAction action) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Stop action %s", action));
        }
    }

    @Override
    public void message(String message) {
        log.info(message);
    }

    @Override
    public void log(TranscriptListener.Type request, String message) {
        log.trace(message);
    }
}

