/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSThread;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Rococoa;

public class Proxy {
    private static final Logger log = LogManager.getLogger(Proxy.class);
    private NSObject proxy;
    private ID id;
    private final Object target;

    public Proxy() {
        this.target = this;
    }

    public Proxy(Object target) {
        this.target = target;
    }

    public NSObject proxy() {
        return this.proxy(NSObject.class);
    }

    protected NSObject proxy(Class<? extends NSObject> type) {
        if (null == this.proxy) {
            this.proxy = (NSObject)Rococoa.proxy((Object)this.target, type);
        }
        return this.proxy;
    }

    public ID id() {
        return this.id(NSObject.class);
    }

    protected ID id(Class<? extends NSObject> type) {
        if (null == this.id) {
            this.id = this.proxy(type).id();
        }
        return this.id;
    }

    public void invalidate() {
        if (this.id != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Runnable runnable, Object lock, boolean wait) {
        if (NSThread.isMainThread()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Already on main thread. Invoke %s directly.", runnable));
            }
            runnable.run();
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Invoke runnable %s on main thread", runnable));
            }
            try {
                Foundation.runOnMainThread((Runnable)runnable, (boolean)wait);
            }
            catch (Exception e) {
                log.error(String.format("Exception %s running task on main thread", e.getMessage()), (Throwable)e);
            }
        }
    }
}

