/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.ui.InputValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSRect;

public abstract class AlertController
extends SheetController
implements SheetCallback,
InputValidator {
    private static final Logger log = LogManager.getLogger(AlertController.class);
    protected static final int SUBVIEWS_VERTICAL_SPACE = 4;
    private boolean suppressed = false;
    private NSAlert alert;

    public AlertController(NSAlert alert) {
        this.loadBundle(alert);
    }

    public AlertController() {
    }

    @Override
    protected String getBundleName() {
        return null;
    }

    public NSView getAccessoryView(NSAlert alert) {
        return null;
    }

    public int beginSheet(WindowController parent) {
        return new SheetInvoker((SheetCallback)this, parent, this).beginSheet();
    }

    @Override
    public void callback(int returncode) {
        log.warn(String.format("Ignore return code %d", returncode));
    }

    @Override
    public void invalidate() {
        this.alert = null;
        super.invalidate();
    }

    @Override
    public void loadBundle() {
    }

    protected void loadBundle(NSAlert alert) {
        this.alert = alert;
        alert.setShowsHelp(true);
        alert.setDelegate(this.id());
        if (alert.showsSuppressionButton()) {
            alert.suppressionButton().setTarget(this.id());
            alert.suppressionButton().setAction(Foundation.selector((String)"suppressionButtonClicked:"));
        }
        this.focus(alert);
        this.setWindow(alert.window());
    }

    protected void focus(NSAlert alert) {
        NSObject button;
        NSEnumerator buttons = alert.buttons().objectEnumerator();
        while ((button = buttons.nextObject()) != null) {
            NSButton b = (NSButton)Rococoa.cast((ObjCObject)button, NSButton.class);
            b.setTarget(this.id());
            b.setAction(Foundation.selector((String)"closeSheet:"));
        }
        NSView accessory = this.getAccessoryView(alert);
        if (accessory != null) {
            NSRect frame = this.getFrame(alert, accessory);
            accessory.setFrameSize(frame.size);
            alert.setAccessoryView(accessory);
            alert.window().makeFirstResponder(accessory);
        }
        alert.layout();
        alert.window().recalculateKeyViewLoop();
    }

    protected NSRect getFrame(NSAlert alert, NSView accessory) {
        NSObject next;
        NSRect frame = new NSRect(alert.window().frame().size.width.doubleValue(), accessory.frame().size.height.doubleValue());
        NSEnumerator enumerator = accessory.subviews().objectEnumerator();
        while (null != (next = enumerator.nextObject())) {
            NSView subview = (NSView)Rococoa.cast((ObjCObject)next, NSView.class);
            frame.size.height = new CGFloat(frame.size.height.doubleValue() + subview.frame().size.height.doubleValue() + 8.0);
        }
        return frame;
    }

    protected String help() {
        return ProviderHelpServiceFactory.get().help();
    }

    public void alertShowHelp(NSAlert alert) {
        BrowserLauncherFactory.get().open(this.help());
    }

    public void suppressionButtonClicked(NSButton sender) {
        this.suppressed = sender.state() == 1;
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }
}

