/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;

public class ChecksumHelper {
    public static String calculateSha1(File file) throws IOException {
        try {
            return ChecksumHelper.calculateSha1(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static String calculateSha1(InputStream in) throws IOException {
        String string;
        BufferedInputStream inputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            inputStream = new BufferedInputStream(in);
            byte[] buffer = new byte[8192];
            int len = ((InputStream)inputStream).read(buffer);
            while (len != -1) {
                messageDigest.update(buffer, 0, len);
                len = ((InputStream)inputStream).read(buffer);
            }
            string = Hex.encodeHexString((byte[])messageDigest.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }
}

