/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.NullInputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.io.HttpMethodReleaseInputStream;

public class B2DownloadFileResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2DownloadFileResponse.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();
    private final Long contentLength;
    private final String contentType;
    private final String fileId;
    private final String fileName;
    private final String contentSha1;
    private final String uploadTimestamp;
    private final Map<String, String> fileInfo = new HashMap<String, String>();
    private final CloseableHttpResponse response;

    public B2DownloadFileResponse(CloseableHttpResponse response) throws B2ApiException {
        this.response = response;
        this.contentLength = Long.parseLong(response.getFirstHeader("Content-Length").getValue());
        this.contentType = response.getFirstHeader("Content-Type").getValue();
        this.contentSha1 = response.getFirstHeader("X-Bz-Content-Sha1").getValue();
        this.fileId = response.getFirstHeader("X-Bz-File-Id").getValue();
        this.fileName = response.getFirstHeader("X-Bz-File-Name").getValue();
        this.uploadTimestamp = response.getFirstHeader("X-Bz-Upload-Timestamp").getValue();
        for (Header header : response.getAllHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            String headerNameLowerCase = headerName.toLowerCase(Locale.ENGLISH);
            if (headerNameLowerCase.startsWith("X-Bz-Info-".toLowerCase(Locale.ENGLISH))) {
                this.fileInfo.put(headerName.substring("X-Bz-Info-".length()), headerValue);
                continue;
            }
            if (ignoredHeaders.contains(headerNameLowerCase)) continue;
            LOGGER.warn("Found a header named '{}' with value '{}', that was not mapped", (Object)headerName, (Object)headerValue);
        }
    }

    public CloseableHttpResponse getResponse() {
        return this.response;
    }

    public InputStream getContent() throws IOException {
        if (null != this.response.getEntity()) {
            return new HttpMethodReleaseInputStream((HttpResponse)this.response);
        }
        return new NullInputStream(0L);
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentSha1() {
        return this.contentSha1;
    }

    public String getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("B2DownloadFileResponse{");
        sb.append("contentLength=").append(this.contentLength);
        sb.append(", contentType='").append(this.contentType).append('\'');
        sb.append(", fileId='").append(this.fileId).append('\'');
        sb.append(", fileName='").append(this.fileName).append('\'');
        sb.append(", contentSha1='").append(this.contentSha1).append('\'');
        sb.append(", uploadTimestamp='").append(this.uploadTimestamp).append('\'');
        sb.append(", fileInfo=").append(this.fileInfo);
        sb.append('}');
        return sb.toString();
    }

    static {
        ignoredHeaders.add("x-xss-protection");
        ignoredHeaders.add("x-frame-options");
        ignoredHeaders.add("Server".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("Accept-Ranges".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("Content-Range".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("Cache-Control".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("Date".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("Content-Length".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("Content-Type".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("X-Bz-Content-Sha1".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("X-Bz-File-Id".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("X-Bz-File-Name".toLowerCase(Locale.ENGLISH));
        ignoredHeaders.add("X-Bz-Upload-Timestamp".toLowerCase(Locale.ENGLISH));
    }
}

