/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.request.BaseB2Request;
import synapticloop.b2.response.B2AuthorizeAccountResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2ListFileNamesRequest
extends BaseB2Request {
    private static final String B2_LIST_FILE_NAMES = "/b2api/v2/b2_list_file_names";
    private static final int DEFAULT_MAX_FILE_COUNT = 100;

    public B2ListFileNamesRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId) {
        this(client, b2AuthorizeAccountResponse, bucketId, null, 100, null, null);
    }

    public B2ListFileNamesRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId, Integer maxFileCount) {
        this(client, b2AuthorizeAccountResponse, bucketId, null, maxFileCount, null, null);
    }

    public B2ListFileNamesRequest(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String bucketId, String startFileName, Integer maxFileCount, String prefix, String delimiter) {
        super(client, b2AuthorizeAccountResponse, b2AuthorizeAccountResponse.getApiUrl() + B2_LIST_FILE_NAMES);
        this.addProperty("bucketId", bucketId);
        if (null != startFileName) {
            this.addProperty("startFileName", startFileName);
        }
        if (null != prefix) {
            this.addProperty("prefix", prefix);
        }
        if (null != delimiter) {
            this.addProperty("delimiter", delimiter);
        }
        this.addProperty("maxFileCount", maxFileCount);
    }

    public B2ListFilesResponse getResponse() throws B2ApiException, IOException {
        return new B2ListFilesResponse(EntityUtils.toString((HttpEntity)this.executePost().getEntity()));
    }
}

