/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.io;

import java.io.IOException;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodReleaseInputStream
extends CountingInputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMethodReleaseInputStream.class);
    private HttpResponse response;

    public HttpMethodReleaseInputStream(HttpResponse response) throws IOException {
        super(response.getEntity().getContent());
        this.response = response;
    }

    public void close() throws IOException {
        if (this.response instanceof CloseableHttpResponse) {
            long read = this.getByteCount();
            if (read == this.response.getEntity().getContentLength()) {
                super.close();
            } else {
                LOGGER.warn("Abort connection for response '{}'", (Object)this.response);
                ((CloseableHttpResponse)this.response).close();
            }
        } else {
            super.close();
        }
    }
}

