/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.freenet;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.MacUniqueIdService;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVRedirectStrategy;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.freenet.FreenetFindFeature;
import ch.cyberduck.core.freenet.FreenetUrlProvider;
import ch.cyberduck.core.freenet.FreenetUserAgentProvider;
import ch.cyberduck.core.http.PreferencesRedirectCallback;
import ch.cyberduck.core.http.RedirectCallback;
import ch.cyberduck.core.io.MD5ChecksumCompute;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FreenetSession
extends DAVSession {
    private static final Logger log = LogManager.getLogger(FreenetSession.class);

    public FreenetSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected DAVClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.setRedirectStrategy((RedirectStrategy)new DAVRedirectStrategy((RedirectCallback)new PreferencesRedirectCallback()));
        configuration.setUserAgent(new FreenetUserAgentProvider().get());
        try {
            final String hash = new MD5ChecksumCompute().compute((String)new MacUniqueIdService().getUUID()).hash;
            configuration.addInterceptorLast(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) {
                    request.addHeader((Header)new BasicHeader("X-Freenet-Insid", hash));
                }
            });
        }
        catch (ChecksumException | LocalAccessDeniedException e) {
            log.warn(String.format("Failure %s retrieving MAC address", e));
            final String identifier = new MD5ChecksumCompute().compute((String)System.getProperty((String)"user.name")).hash;
            configuration.addInterceptorLast(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) {
                    request.addHeader((Header)new BasicHeader("X-Freenet-Insid", identifier));
                }
            });
        }
        return new DAVClient(new HostUrlProvider().withUsername(false).get(this.host), configuration);
    }

    public <T> T getFeature(Class<T> type) {
        if (type == UrlProvider.class) {
            return (T)new FreenetUrlProvider(this.host);
        }
        if (type == Find.class) {
            return (T)((Object)new FreenetFindFeature(this));
        }
        if (type == Timestamp.class) {
            return null;
        }
        return (T)super.getFeature(type);
    }
}

