/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.freenet;

import ch.cyberduck.core.CertificateIdentityCallback;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.CertificateTrustCallback;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledCertificateIdentityCallback;
import ch.cyberduck.core.DisabledCertificateTrustCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.DisabledTranscriptListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.WebUrlProvider;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.freenet.FreenetTemporaryLoginResponse;
import ch.cyberduck.core.freenet.FreenetUserAgentProvider;
import ch.cyberduck.core.http.HttpConnectionPoolBuilder;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.UserAgentHttpRequestInitializer;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.PasswordTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FreenetAuthenticatedUrlProvider
implements WebUrlProvider {
    private static final Logger log = LogManager.getLogger(FreenetAuthenticatedUrlProvider.class);
    private final HostPasswordStore keychain;

    public FreenetAuthenticatedUrlProvider() {
        this(PasswordStoreFactory.get());
    }

    public FreenetAuthenticatedUrlProvider(HostPasswordStore keychain) {
        this.keychain = keychain;
    }

    public DescriptiveUrl toUrl(Host bookmark) {
        try {
            try {
                Host target = new Host((Protocol)new DAVSSLProtocol(), "oauth.freenet.de");
                KeychainX509TrustManager trust = new KeychainX509TrustManager((CertificateTrustCallback)new DisabledCertificateTrustCallback(), (TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(target), CertificateStoreFactory.get());
                KeychainX509KeyManager key = new KeychainX509KeyManager((CertificateIdentityCallback)new DisabledCertificateIdentityCallback(), target, CertificateStoreFactory.get());
                CloseableHttpClient client = new HttpConnectionPoolBuilder(target, new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)trust, target.getHostname()), (X509KeyManager)key, ProxyFactory.get()).build(ProxyFactory.get().find(new ProxyHostUrlProvider().get(target)), (TranscriptListener)new DisabledTranscriptListener(), (LoginCallback)new DisabledLoginCallback()).setUserAgent(new FreenetUserAgentProvider().get()).build();
                String username = bookmark.getCredentials().getUsername();
                String password = StringUtils.isBlank((CharSequence)bookmark.getCredentials().getPassword()) ? this.keychain.findLoginPassword(bookmark) : bookmark.getCredentials().getPassword();
                if (null == password) {
                    log.warn(String.format("No password found for %s", bookmark));
                    return DescriptiveUrl.EMPTY;
                }
                TokenResponse response = new PasswordTokenRequest((HttpTransport)new ApacheHttpTransport((HttpClient)client), (JsonFactory)new GsonFactory(), new GenericUrl("https://oauth.freenet.de/oauth/token"), username, password).setClientAuthentication((HttpExecuteInterceptor)new BasicAuthentication("desktop_client", "6LIGIHuOSkznLomu5xw0EPPBJOXb2jLp")).setRequestInitializer((HttpRequestInitializer)new UserAgentHttpRequestInitializer((UseragentProvider)new FreenetUserAgentProvider())).set("world", (Object)new HostPreferences(bookmark).getProperty("world")).set("webLogin", (Object)Boolean.TRUE).execute();
                FreenetTemporaryLoginResponse login = this.getLoginSession((HttpClient)client, response.getAccessToken());
                return new DescriptiveUrl(URI.create(login.urls.login), DescriptiveUrl.Type.authenticated);
            }
            catch (IOException e) {
                throw new HttpExceptionMappingService().map(e);
            }
        }
        catch (BackgroundException e) {
            log.warn(String.format("Failure %s retrieving authenticated URL for %s", new Object[]{e, bookmark}));
            return DescriptiveUrl.EMPTY;
        }
    }

    private FreenetTemporaryLoginResponse getLoginSession(HttpClient client, String token) throws BackgroundException {
        HttpGet request = new HttpGet("https://api.mail.freenet.de/v2.0/hash/create");
        request.addHeader("Token", token);
        try {
            return (FreenetTemporaryLoginResponse)client.execute((HttpUriRequest)request, (ResponseHandler)new AbstractResponseHandler<FreenetTemporaryLoginResponse>(){

                public FreenetTemporaryLoginResponse handleEntity(HttpEntity entity) throws IOException {
                    ObjectMapper mapper = new ObjectMapper();
                    return (FreenetTemporaryLoginResponse)mapper.readValue(entity.getContent(), FreenetTemporaryLoginResponse.class);
                }
            });
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e);
        }
    }
}

