/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.parser;

import java.util.List;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompositeFileEntryParser
extends FTPFileEntryParserImpl
implements Configurable {
    private static final Logger log = LogManager.getLogger(CompositeFileEntryParser.class);
    private final List<? extends FTPFileEntryParser> parsers;
    private FTPFileEntryParser current;

    public CompositeFileEntryParser(List<? extends FTPFileEntryParser> parsers) {
        this.parsers = parsers;
    }

    public List<String> preParse(List<String> original) {
        for (FTPFileEntryParser fTPFileEntryParser : this.parsers) {
            fTPFileEntryParser.preParse(original);
        }
        return original;
    }

    public FTPFile parseFTPEntry(String line) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Parse %s", line));
        }
        if (this.current != null) {
            FTPFile parsed = this.current.parseFTPEntry(line);
            if (null != parsed) {
                return parsed;
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("Switching parser implementation because %s failed", this.current));
            }
            this.current = null;
        }
        for (FTPFileEntryParser fTPFileEntryParser : this.parsers) {
            FTPFile matched = fTPFileEntryParser.parseFTPEntry(line);
            if (matched == null) continue;
            this.current = fTPFileEntryParser;
            if (log.isInfoEnabled()) {
                log.info(String.format("Caching %s parser implementation", this.current));
            }
            return matched;
        }
        log.warn(String.format("Failure parsing line %s", line));
        return null;
    }

    public FTPFileEntryParser getCurrent() {
        return this.current;
    }

    public void configure(FTPClientConfig config) {
        for (FTPFileEntryParser fTPFileEntryParser : this.parsers) {
            if (!(fTPFileEntryParser instanceof Configurable)) continue;
            ((Configurable)fTPFileEntryParser).configure(config);
        }
    }
}

