/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.list;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.date.MDTMMillisecondsDateFormatter;
import ch.cyberduck.core.date.MDTMSecondsDateFormatter;
import ch.cyberduck.core.ftp.list.FTPDataResponseReader;
import ch.cyberduck.core.ftp.list.FTPInvalidListException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTPMlsdListResponseReader
implements FTPDataResponseReader {
    private static final Logger log = LogManager.getLogger(FTPMlsdListResponseReader.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public AttributedList<Path> read(Path directory, List<String> replies, ListProgressListener listener) throws FTPInvalidListException {
        children = new AttributedList();
        if (replies.isEmpty()) {
            return children;
        }
        success = false;
        for (String line : replies) {
            file = this.parseFacts(line);
            if (null == file) {
                FTPMlsdListResponseReader.log.error(String.format("Error parsing line %s", new Object[]{line}));
                continue;
            }
            for (Map.Entry<String, Map<String, String>> f : file.entrySet()) {
                block29: {
                    block30: {
                        block28: {
                            name = f.getKey();
                            facts = f.getValue();
                            if (!facts.containsKey("type")) {
                                FTPMlsdListResponseReader.log.error(String.format("No type fact in line %s", new Object[]{line}));
                                continue;
                            }
                            if (!"dir".equals(facts.get("type").toLowerCase(Locale.ROOT))) break block28;
                            parsed = new Path(directory, PathNormalizer.name((String)f.getKey()), EnumSet.of(AbstractPath.Type.directory));
                            break block29;
                        }
                        if (!"file".equals(facts.get("type").toLowerCase(Locale.ROOT))) break block30;
                        parsed = new Path(directory, PathNormalizer.name((String)f.getKey()), EnumSet.of(AbstractPath.Type.file));
                        break block29;
                    }
                    if (!facts.get("type").toLowerCase(Locale.ROOT).matches("os\\.unix=slink:.*")) ** GOTO lbl36
                    parsed = new Path(directory, PathNormalizer.name((String)f.getKey()), EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.symboliclink));
                    type = facts.get("type").split(":");
                    if (type.length == 2) {
                        target = type[1];
                        if (target.startsWith(String.valueOf('/'))) {
                            parsed.setSymlinkTarget(new Path(PathNormalizer.normalize((String)target), EnumSet.of(AbstractPath.Type.file)));
                        } else {
                            parsed.setSymlinkTarget(new Path(PathNormalizer.normalize((String)String.format("%s/%s", new Object[]{directory.getAbsolute(), target})), EnumSet.of(AbstractPath.Type.file)));
                        }
                    } else {
                        FTPMlsdListResponseReader.log.warn(String.format("Missing symbolic link target for type %s in line %s", new Object[]{facts.get("type"), line}));
                        continue;
lbl36:
                        // 1 sources

                        FTPMlsdListResponseReader.log.warn(String.format("Ignored type %s in line %s", new Object[]{facts.get("type"), line}));
                        continue;
                    }
                }
                if (!success) {
                    if (parsed.isDirectory() && directory.getName().equals(name)) {
                        FTPMlsdListResponseReader.log.warn(String.format("Possibly bogus response line %s", new Object[]{line}));
                    } else {
                        success = true;
                    }
                }
                if (name.equals(".") || name.equals("..")) {
                    if (!FTPMlsdListResponseReader.log.isDebugEnabled()) continue;
                    FTPMlsdListResponseReader.log.debug(String.format("Skip %s", new Object[]{name}));
                    continue;
                }
                if (facts.containsKey("size")) {
                    parsed.attributes().setSize(Long.parseLong(facts.get("size")));
                }
                if (facts.containsKey("unix.uid")) {
                    parsed.attributes().setOwner(facts.get("unix.uid"));
                }
                if (facts.containsKey("unix.owner")) {
                    parsed.attributes().setOwner(facts.get("unix.owner"));
                }
                if (facts.containsKey("unix.gid")) {
                    parsed.attributes().setGroup(facts.get("unix.gid"));
                }
                if (facts.containsKey("unix.group")) {
                    parsed.attributes().setGroup(facts.get("unix.group"));
                }
                if (facts.containsKey("unix.mode")) {
                    parsed.attributes().setPermission(new Permission(facts.get("unix.mode")));
                } else if (facts.containsKey("perm") && PreferencesFactory.get().getBoolean("ftp.parser.mlsd.perm.enable")) {
                    user = Permission.Action.none;
                    flags = facts.get("perm");
                    if (StringUtils.contains((CharSequence)flags, (int)114) || StringUtils.contains((CharSequence)flags, (int)108)) {
                        user = user.or(Permission.Action.read);
                    }
                    if (StringUtils.contains((CharSequence)flags, (int)119) || StringUtils.contains((CharSequence)flags, (int)109) || StringUtils.contains((CharSequence)flags, (int)99)) {
                        user = user.or(Permission.Action.write);
                    }
                    if (StringUtils.contains((CharSequence)flags, (int)101)) {
                        user = user.or(Permission.Action.execute);
                        if (parsed.isDirectory()) {
                            user = user.or(Permission.Action.read);
                        }
                    }
                    permission = new Permission(user, Permission.Action.none, Permission.Action.none);
                    parsed.attributes().setPermission(permission);
                }
                if (facts.containsKey("modify")) {
                    parsed.attributes().setModificationDate(this.parseTimestamp(facts.get("modify")));
                }
                if (facts.containsKey("create")) {
                    parsed.attributes().setCreationDate(this.parseTimestamp(facts.get("create")));
                }
                children.add((Referenceable)parsed);
            }
        }
        if (!success) {
            throw new FTPInvalidListException((AttributedList<Path>)children);
        }
        return children;
    }

    protected long parseTimestamp(String timestamp) {
        if (null == timestamp) {
            return -1L;
        }
        try {
            Date parsed = new MDTMSecondsDateFormatter().parse(timestamp);
            return parsed.getTime();
        }
        catch (InvalidDateException e) {
            log.warn("Failed to parse timestamp:" + e.getMessage());
            try {
                Date parsed = new MDTMMillisecondsDateFormatter().parse(timestamp);
                return parsed.getTime();
            }
            catch (InvalidDateException f) {
                log.warn("Failed to parse timestamp:" + f.getMessage());
                log.error(String.format("Failed to parse timestamp %s", timestamp));
                return -1L;
            }
        }
    }

    protected Map<String, Map<String, String>> parseFacts(String line) {
        Pattern p = Pattern.compile("\\s?(\\S+\\=\\S+;)*\\s(.*)");
        Matcher result = p.matcher(line);
        HashMap<String, Map<String, String>> file = new HashMap<String, Map<String, String>>();
        if (result.matches()) {
            String filename = result.group(2);
            HashMap<String, String> facts = new HashMap<String, String>();
            for (String fact : result.group(1).split(";")) {
                String value;
                String key = StringUtils.substringBefore((String)fact, (String)"=");
                if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)(value = StringUtils.substringAfter((String)fact, (String)"=")))) continue;
                facts.put(key.toLowerCase(Locale.ROOT), value);
            }
            file.put(filename, facts);
            return file;
        }
        log.warn(String.format("No match for %s", line));
        return null;
    }
}

