/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.ftp.FTPAttributesFinderFeature;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;

public class FTPDirectoryFeature
implements Directory<Integer> {
    private final FTPSession session;

    public FTPDirectoryFeature(FTPSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            if (!((FTPClient)((Object)this.session.getClient())).makeDirectory(folder.getAbsolute())) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
            return folder.withAttributes(new FTPAttributesFinderFeature(this.session).find(folder));
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public FTPDirectoryFeature withWriter(Write writer) {
        return this;
    }
}

