/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTPClient
extends FTPSClient {
    private static final Logger log = LogManager.getLogger(FTPClient.class);
    private final SSLSocketFactory sslSocketFactory;
    private Protocol protocol;
    private Map<String, Set<String>> features;
    private final Preferences preferences = PreferencesFactory.get();

    public FTPClient(Protocol protocol, SSLSocketFactory f, SSLContext c) {
        super(false, c);
        this.protocol = protocol;
        this.sslSocketFactory = f;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    protected Socket _openDataConnection_(String command, String arg) throws IOException {
        Socket socket = super._openDataConnection_(command, arg);
        if (null == socket) {
            throw new FTPException(this.getReplyCode(), this.getReplyString());
        }
        return socket;
    }

    protected void _prepareDataSocket_(Socket socket) {
        if (this.preferences.getBoolean("ftp.tls.session.requirereuse") && socket instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this._socket_).getSession();
            if (session.isValid()) {
                SSLSessionContext context = session.getSessionContext();
                context.setSessionCacheSize(this.preferences.getInteger("ftp.ssl.session.cache.size"));
                try {
                    Method getHostMethod;
                    Field sessionHostPortCache = context.getClass().getDeclaredField("sessionHostPortCache");
                    sessionHostPortCache.setAccessible(true);
                    Object cache = sessionHostPortCache.get(context);
                    Method putMethod = cache.getClass().getDeclaredMethod("put", Object.class, Object.class);
                    putMethod.setAccessible(true);
                    try {
                        getHostMethod = socket.getClass().getMethod("getPeerHost", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        getHostMethod = socket.getClass().getDeclaredMethod("getHost", new Class[0]);
                    }
                    getHostMethod.setAccessible(true);
                    Object peerHost = getHostMethod.invoke((Object)socket, new Object[0]);
                    putMethod.invoke(cache, String.format("%s:%s", peerHost, socket.getPort()).toLowerCase(Locale.ROOT), session);
                }
                catch (NoSuchFieldException e) {
                    log.warn("No field sessionHostPortCache in SSLSessionContext", (Throwable)e);
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            } else {
                log.warn(String.format("SSL session %s for socket %s is not rejoinable", session, socket));
            }
        }
    }

    protected void execAUTH() throws IOException {
        if (this.protocol.isSecure() && 234 != this.sendCommand("AUTH", this.getAuthValue())) {
            throw new FTPException(this.getReplyCode(), this.getReplyString());
        }
    }

    public void execPROT(String prot) throws IOException {
        if (this.protocol.isSecure()) {
            if (200 != this.sendCommand("PROT", prot)) {
                throw new FTPException(this.getReplyCode(), this.getReplyString());
            }
            if ("P".equals(prot)) {
                this.setSocketFactory(this.sslSocketFactory);
            }
        }
    }

    public void execPBSZ(long pbsz) throws IOException {
        if (this.protocol.isSecure() && 200 != this.sendCommand("PBSZ", String.valueOf(pbsz))) {
            throw new FTPException(this.getReplyCode(), this.getReplyString());
        }
    }

    protected void sslNegotiation() throws IOException {
        if (this.protocol.isSecure()) {
            SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(this._socket_, this._socket_.getInetAddress().getHostName(), this._socket_.getPort(), false);
            socket.setEnableSessionCreation(true);
            socket.setUseClientMode(true);
            socket.startHandshake();
            this._socket_ = socket;
            this._controlInput_ = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
            this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.getControlEncoding()));
        }
    }

    public List<String> list(FTPCmd command) throws IOException {
        return this.list(command, null);
    }

    public List<String> list(FTPCmd command, String pathname) throws IOException {
        String line;
        this.pret(command, pathname);
        Socket socket = this._openDataConnection_(command, pathname);
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
        ArrayList<String> results = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            this._commandSupport_.fireReplyReceived(-1, line);
            results.add(line);
        }
        reader.close();
        socket.close();
        if (!this.completePendingCommand()) {
            throw new FTPException(this.getReplyCode(), this.getReplyString());
        }
        return results;
    }

    public String[] featureValues(String feature) throws IOException {
        if (!this.initFeatureMap()) {
            return null;
        }
        Set<String> entries = this.features.get(feature.toUpperCase(Locale.ROOT));
        if (entries != null) {
            return entries.toArray(new String[entries.size()]);
        }
        return null;
    }

    public String featureValue(String feature) throws IOException {
        String[] values = this.featureValues(feature);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public boolean hasFeature(String feature) throws IOException {
        if (!this.initFeatureMap()) {
            return false;
        }
        return this.features.containsKey(feature.toUpperCase(Locale.ROOT));
    }

    public boolean hasFeature(String feature, String value) throws IOException {
        if (!this.initFeatureMap()) {
            return false;
        }
        Set<String> entries = this.features.get(feature.toUpperCase(Locale.ROOT));
        if (entries != null) {
            return entries.contains(value);
        }
        return false;
    }

    private boolean initFeatureMap() throws IOException {
        if (this.features == null) {
            int reply = this.feat();
            if (530 == reply) {
                return false;
            }
            this.features = new HashMap<String, Set<String>>();
            boolean success = FTPReply.isPositiveCompletion((int)reply);
            if (!success) {
                return false;
            }
            for (String l : this.getReplyStrings()) {
                String key;
                if (!l.startsWith(" ")) continue;
                String value = "";
                int varsep = l.indexOf(32, 1);
                if (varsep > 0) {
                    key = l.substring(1, varsep);
                    value = l.substring(varsep + 1);
                } else {
                    key = l.substring(1);
                }
                key = key.toUpperCase(Locale.ROOT);
                Set entries = this.features.computeIfAbsent(key, k -> new HashSet());
                entries.add(value);
            }
        }
        return true;
    }

    public boolean retrieveFile(String remote, OutputStream local) throws IOException {
        this.pret(FTPCmd.RETR, remote);
        return super.retrieveFile(remote, local);
    }

    public InputStream retrieveFileStream(String remote) throws IOException {
        this.pret(FTPCmd.RETR, remote);
        return super.retrieveFileStream(remote);
    }

    public boolean storeFile(String remote, InputStream local) throws IOException {
        this.pret(FTPCmd.STOR, remote);
        return super.storeFile(remote, local);
    }

    public OutputStream storeFileStream(String remote) throws IOException {
        this.pret(FTPCmd.STOR, remote);
        return super.storeFileStream(remote);
    }

    public boolean appendFile(String remote, InputStream local) throws IOException {
        this.pret(FTPCmd.APPE, remote);
        return super.appendFile(remote, local);
    }

    public OutputStream appendFileStream(String remote) throws IOException {
        this.pret(FTPCmd.APPE, remote);
        return super.appendFileStream(remote);
    }

    protected void pret(FTPCmd command, String file) throws IOException {
        if (this.hasFeature("PRET") && !FTPReply.isPositiveCompletion((int)this.sendCommand("PRET", String.format("%s %s", command.getCommand(), file)))) {
            throw new FTPException(this.getReplyCode(), this.getReplyString());
        }
    }

    public String getModificationTime(String file) throws IOException {
        String status = super.getModificationTime(file);
        if (null == status) {
            throw new FTPException(this.getReplyCode(), this.getReplyString());
        }
        return StringUtils.chomp((String)status.substring(3).trim());
    }
}

