/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VoidAttributesAdapter;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.ftp.list.FTPMlsdListResponseReader;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTPAttributesFinderFeature
extends VoidAttributesAdapter
implements AttributesFinder {
    private static final Logger log = LogManager.getLogger(FTPAttributesFinderFeature.class);
    private final FTPSession session;

    public FTPAttributesFinderFeature(FTPSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            try {
                if (((FTPClient)((Object)this.session.getClient())).hasFeature(FTPCmd.MLST.getCommand())) {
                    if (!FTPReply.isPositiveCompletion((int)((FTPClient)((Object)this.session.getClient())).sendCommand(FTPCmd.MLST, file.getAbsolute()))) {
                        throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
                    }
                    FTPMlsdListResponseReader reader = new FTPMlsdListResponseReader();
                    AttributedList<Path> attributes = reader.read(file.getParent(), Arrays.asList(((FTPClient)((Object)this.session.getClient())).getReplyStrings()), listener);
                    if (attributes.contains((Referenceable)file)) {
                        return ((Path)attributes.get(attributes.indexOf((Referenceable)file))).attributes();
                    }
                }
                log.warn("No support for MLST in reply to FEAT");
                return new DefaultAttributesFinderFeature((Session)this.session).find(file, listener);
            }
            catch (IOException e) {
                throw new FTPExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
        }
        catch (AccessDeniedException | InteroperabilityException | NotfoundException f) {
            log.warn(String.format("Failure reading attributes for %s. %s", file, f.getMessage()));
            return new DefaultAttributesFinderFeature((Session)this.session).find(file, listener);
        }
    }
}

