/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.ftp.DataConnectionAction;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataConnectionActionExecutor {
    private static final Logger log = LogManager.getLogger(DataConnectionActionExecutor.class);
    private final FTPSession session;
    private final boolean enabled;

    public DataConnectionActionExecutor(FTPSession session) {
        this(session, PreferencesFactory.get().getBoolean("ftp.connectmode.fallback"));
    }

    public DataConnectionActionExecutor(FTPSession session, boolean enabled) {
        this.session = session;
        this.enabled = enabled;
    }

    public <T> T data(DataConnectionAction<T> action, ProgressListener listener) throws IOException, BackgroundException {
        try {
            FTPConnectMode mode = this.session.getConnectMode();
            switch (mode) {
                case active: {
                    ((FTPClient)((Object)this.session.getClient())).enterLocalActiveMode();
                    break;
                }
                case passive: {
                    ((FTPClient)((Object)this.session.getClient())).enterLocalPassiveMode();
                }
            }
            return action.execute();
        }
        catch (ConnectionTimeoutException failure) {
            log.warn(String.format("Timeout opening data socket %s", failure.getMessage()));
            ((FTPClient)((Object)this.session.getClient())).completePendingCommand();
            if (this.enabled) {
                try {
                    return this.fallback(action);
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Connect mode fallback failed with %s", e.getMessage()));
                }
            }
            throw failure;
        }
        catch (AccessDeniedException | InteroperabilityException | NotfoundException failure) {
            log.warn(String.format("Server denied data socket operation with %s", failure.getMessage()));
            if (this.enabled) {
                try {
                    return this.fallback(action);
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Connect mode fallback failed with %s", e.getMessage()));
                }
            }
            throw failure;
        }
    }

    protected <T> T fallback(DataConnectionAction<T> action) throws BackgroundException {
        if (((FTPClient)((Object)this.session.getClient())).getDataConnectionMode() == 2) {
            log.warn("Fallback to active data connection");
            ((FTPClient)((Object)this.session.getClient())).enterLocalActiveMode();
        } else if (((FTPClient)((Object)this.session.getClient())).getDataConnectionMode() == 0) {
            log.warn("Fallback to passive data connection");
            ((FTPClient)((Object)this.session.getClient())).enterLocalPassiveMode();
        }
        return action.execute();
    }
}

