/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonObject;
import java.util.Optional;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.types.DirectoryObject;

public class User
extends DirectoryObject {
    private final UserIdType userIdType;

    public User(OneDriveAPI api, String id) {
        this(api, id, UserIdType.UUID);
    }

    User(OneDriveAPI api, String id, UserIdType userIdType) {
        super(api, id);
        this.userIdType = userIdType;
    }

    public static User getCurrent(OneDriveAPI api) {
        return new User(api, "me", null);
    }

    @Override
    public String getPath() {
        if (null == this.userIdType) {
            return "/" + this.getId();
        }
        return "/users/" + this.getId();
    }

    public String getOperationPath(String operation) {
        return this.getPath() + "/" + operation;
    }

    static enum UserIdType {
        UUID;

    }

    public class Metadata
    extends DirectoryObject.Metadata {
        private Optional<String> creationType;
        private String userPrincipalName;

        public Metadata(JsonObject jsonObject) {
            super(User.this, jsonObject);
        }

        public Optional<String> getCreationType() {
            return this.creationType;
        }

        public String getUserPrincipalName() {
            return this.userPrincipalName;
        }

        @Override
        public User asDirectoryObject() {
            return User.this;
        }

        @Override
        protected boolean parseMemberUnsafe(JsonObject.Member member) {
            if ("creationType".equals(member.getName())) {
                this.creationType = member.getValue().isNull() ? Optional.empty() : Optional.ofNullable(member.getValue().asString());
                return true;
            }
            return super.parseMemberUnsafe(member);
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            switch (member.getName()) {
                case "aboutMe": 
                case "accountEnabled": 
                case "ageGroup": 
                case "assignedLicenses": 
                case "assignedPlans": 
                case "birthday": 
                case "businessPhones": 
                case "city": 
                case "companyName": 
                case "consentProvidedForMinor": 
                case "country": 
                case "createdDateTime": {
                    break;
                }
                case "department": 
                case "displayName": 
                case "employeeHireDate": 
                case "employeeId": 
                case "employeeOrgData": 
                case "employeeType": 
                case "faxNumber": 
                case "givenName": 
                case "hireDate": 
                case "identities": 
                case "imAddresses": 
                case "interests": 
                case "isResourceAccount": 
                case "jobTitle": 
                case "legalAgeGroupClassification": 
                case "licenseAssignmentStates": 
                case "lastPasswordChangeDateTime": 
                case "mail": 
                case "mailboxSettings": 
                case "mailNickname": 
                case "mobilePhone": 
                case "mySite": 
                case "officeLocation": 
                case "onPremisesDistinguishedName": 
                case "onPremisesDomainName": 
                case "onPremisesExtensionAttributes": 
                case "onPremisesImmutableId": 
                case "onPremisesLastSyncDateTime": 
                case "onPremisesProvisioningErrors": 
                case "onPremisesSamAccountName": 
                case "onPremisesSecurityIdentifier": 
                case "onPremisesSyncEnabled": 
                case "onPremisesUserPrincipalName": 
                case "otherMails": 
                case "passwordPolicies": 
                case "passwordProfile": 
                case "pastProjects": 
                case "postalCode": 
                case "preferredLanguage": 
                case "preferredName": 
                case "provisionedPlans": 
                case "proxyAddresses": 
                case "responsibilities": 
                case "schools": 
                case "showInAddressList": 
                case "signInSessionsValidFromDateTime": 
                case "skills": 
                case "state": 
                case "streetAddress": 
                case "surname": 
                case "usageLocation": {
                    break;
                }
                case "userPrincipalName": {
                    this.userPrincipalName = member.getValue().asString();
                    break;
                }
                case "userType": {
                    break;
                }
                default: {
                    super.parseMember(member);
                }
            }
        }
    }

    public static enum Select implements QueryStringCommaParameter
    {
        CreationType("creationType"),
        UserPrincipalName("userPrincipalName");

        private final String key;

        private Select(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }
}

