/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.BaseItem;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.Quota;
import org.nuxeo.onedrive.client.types.Root;
import org.nuxeo.onedrive.client.types.SharePointIds;
import org.nuxeo.onedrive.client.types.Site;

public class Drive
extends BaseItem {
    private final DriveParent parent;

    public Drive(OneDriveAPI api) {
        super(api);
        this.parent = null;
    }

    public Drive(OneDriveAPI api, String id) {
        super(api, id);
        this.parent = null;
    }

    public Drive(Site parent) {
        super(parent.getApi());
        this.parent = new SiteParent(parent);
    }

    public Drive(Site parent, String id) {
        super(parent.getApi(), id);
        this.parent = new SiteParent(parent);
    }

    public Drive(DirectoryObject parent) {
        super(parent.getApi());
        this.parent = new DirectoryObjectParent(parent);
    }

    public Drive(DirectoryObject parent, String id) {
        super(parent.getApi(), id);
        this.parent = new DirectoryObjectParent(parent);
    }

    private static List<DriveItem.Metadata> map(JsonArray array, OneDriveAPI api) {
        return array.values().stream().map(x -> DriveItem.parseJson(api, x.asObject())).collect(Collectors.toList());
    }

    @Override
    public String getPath() {
        String id = this.getId();
        String action = null == id ? "/drive" : "/drives/" + id;
        if (null == this.parent) {
            return action;
        }
        if (this.parent instanceof SiteParent) {
            return ((Site)((SiteParent)this.parent).getParent()).getAction(action);
        }
        if (this.parent instanceof DirectoryObjectParent) {
            return ((DirectoryObject)((DirectoryObjectParent)this.parent).getParent()).getPath() + action;
        }
        return "";
    }

    @Override
    public String getAction(String action) {
        return this.getPath() + action;
    }

    public DriveItem getRoot() {
        return new DriveItem(this);
    }

    @Override
    public Metadata getMetadata(ODataQuery query) throws IOException {
        URL url = new URLTemplate(this.getPath()).build(this.getApi().getBaseURL(), query, new Object[0]);
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        return (Metadata)new Metadata().fromJson(response.getContent());
    }

    private static abstract class DriveParent<T> {
        private final T parent;

        DriveParent(T parent) {
            this.parent = parent;
        }

        public T getParent() {
            return this.parent;
        }
    }

    private static class SiteParent
    extends DriveParent<Site> {
        SiteParent(Site parent) {
            super(parent);
        }
    }

    private static class DirectoryObjectParent
    extends DriveParent<DirectoryObject> {
        DirectoryObjectParent(DirectoryObject parent) {
            super(parent);
        }
    }

    public class Metadata
    extends BaseItem.Metadata<Metadata> {
        private DriveType driveType;
        private List<DriveItem.Metadata> following;
        private List<DriveItem.Metadata> items;
        private OneDriveIdentitySet owner;
        private Quota quota;
        private Root root;
        private SharePointIds sharePointIds;
        private List<DriveItem.Metadata> special;

        public Metadata() {
            super(Drive.this);
        }

        public DriveType getDriveType() {
            return this.driveType;
        }

        public List<DriveItem.Metadata> getFollowing() {
            return this.following;
        }

        public List<DriveItem.Metadata> getItems() {
            return this.items;
        }

        public OneDriveIdentitySet getOwner() {
            return this.owner;
        }

        public Quota getQuota() {
            return this.quota;
        }

        public Root getRoot() {
            return this.root;
        }

        public SharePointIds getSharePointIds() {
            return this.sharePointIds;
        }

        public List<DriveItem.Metadata> getSpecial() {
            return this.special;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            switch (member.getName()) {
                case "driveType": {
                    this.driveType = DriveType.valueOf(member.getValue().asString());
                    break;
                }
                case "following": {
                    this.following = Drive.map(member.getValue().asArray(), Drive.this.getApi());
                    break;
                }
                case "items": {
                    this.items = Drive.map(member.getValue().asArray(), Drive.this.getApi());
                    break;
                }
                case "owner": {
                    this.owner = new OneDriveIdentitySet(member.getValue().asObject());
                    break;
                }
                case "quota": {
                    this.quota = (Quota)new Quota().fromJson(member.getValue().asObject());
                    break;
                }
                case "root": {
                    this.root = (Root)new Root().fromJson(member.getValue().asObject());
                    break;
                }
                case "sharepointIds": {
                    this.sharePointIds = (SharePointIds)new SharePointIds().fromJson(member.getValue().asObject());
                    break;
                }
                case "special": {
                    this.special = Drive.map(member.getValue().asArray(), Drive.this.getApi());
                }
                case "system": {
                    break;
                }
                default: {
                    super.parseMember(member);
                }
            }
        }
    }

    public static interface IDriveProperty
    extends BaseItem.IBaseItemProperty {
    }

    public static enum Property implements IDriveProperty
    {
        DriveType,
        Following,
        Items,
        Owner,
        Quota,
        Root,
        SharepointIds,
        Special,
        System;


        @Override
        public String getKey() {
            return this.name();
        }
    }

    public static enum DriveType {
        personal,
        business,
        documentLibrary;

    }
}

