/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client.types;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.time.ZonedDateTime;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.types.GraphType;
import org.nuxeo.onedrive.client.types.ItemReference;

public abstract class BaseItem {
    private final OneDriveAPI api;
    private final String id;

    public OneDriveAPI getApi() {
        return this.api;
    }

    public String getId() {
        return this.id;
    }

    public BaseItem(OneDriveAPI api) {
        this.api = api;
        this.id = null;
    }

    public BaseItem(OneDriveAPI api, String id) {
        this.api = api;
        this.id = id;
    }

    public abstract String getPath();

    public abstract String getAction(String var1);

    public abstract Metadata getMetadata(ODataQuery var1) throws IOException;

    public static enum Property implements IBaseItemProperty
    {
        Id,
        CreatedBy,
        CreatedDateTime,
        Description,
        ETag,
        LastModifiedBy,
        LastModifiedDateTime,
        Name,
        ParentReference,
        WebUrl;


        @Override
        public String getKey() {
            return this.name();
        }
    }

    public static interface IBaseItemProperty
    extends QueryStringCommaParameter {
    }

    public abstract class Metadata<T extends Metadata<T>>
    extends GraphType<T> {
        private String id;
        private OneDriveIdentitySet createdBy;
        private ZonedDateTime createdDateTime;
        private String description;
        private String eTag;
        private OneDriveIdentitySet lastModifiedBy;
        private ZonedDateTime lastModifiedDateTime;
        private String name;
        private ItemReference parentReference;
        private String webUrl;

        public String getId() {
            if (this.id != null) {
                return this.id;
            }
            return BaseItem.this.id;
        }

        public BaseItem getItem() {
            return BaseItem.this;
        }

        public OneDriveIdentitySet getCreatedBy() {
            return this.createdBy;
        }

        public ZonedDateTime getCreatedDateTime() {
            return this.createdDateTime;
        }

        public String getDescription() {
            return this.description;
        }

        public String getETag() {
            return this.eTag;
        }

        public OneDriveIdentitySet getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public ZonedDateTime getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public String getName() {
            return this.name;
        }

        public ItemReference getParentReference() {
            return this.parentReference;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            switch (member.getName()) {
                case "id": {
                    this.id = member.getValue().asString();
                    break;
                }
                case "createdBy": {
                    this.createdBy = new OneDriveIdentitySet(member.getValue().asObject());
                    break;
                }
                case "createdDateTime": {
                    this.createdDateTime = ZonedDateTime.parse(member.getValue().asString());
                    break;
                }
                case "description": {
                    this.description = member.getValue().asString();
                    break;
                }
                case "eTag": {
                    this.eTag = member.getValue().asString();
                    break;
                }
                case "lastModifiedBy": {
                    this.lastModifiedBy = new OneDriveIdentitySet(member.getValue().asObject());
                    break;
                }
                case "lastModifiedDateTime": {
                    this.lastModifiedDateTime = ZonedDateTime.parse(member.getValue().asString());
                    break;
                }
                case "name": {
                    this.name = member.getValue().asString();
                    break;
                }
                case "parentReference": {
                    this.parentReference = (ItemReference)new ItemReference().fromJson(member.getValue().asObject());
                    break;
                }
                case "webUrl": {
                    this.webUrl = member.getValue().asString();
                    break;
                }
                default: {
                    super.parseMember(member);
                }
            }
        }
    }
}

