/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.User;

public class Users {
    public static User.Metadata get(User user, ODataQuery query) throws IOException {
        URL url = new URLTemplate(user.getPath()).build(user.getApi().getBaseURL(), query, new Object[0]);
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(user.getApi().getExecutor());
        JsonObject jsonObject = response.getContent();
        response.close();
        User user2 = user;
        Objects.requireNonNull(user2);
        return new User.Metadata(user2, jsonObject);
    }

    public static Iterator<DirectoryObject.Metadata> memberOf(OneDriveAPI api, User user) {
        return new MemberOfIterator(api, new URLTemplate(user.getOperationPath("memberOf")).build(api.getBaseURL()));
    }

    private static class MemberOfIterator
    implements Iterator<DirectoryObject.Metadata> {
        private final OneDriveAPI api;
        private final JsonObjectIterator iterator;

        MemberOfIterator(OneDriveAPI api, URL url) {
            this.api = api;
            this.iterator = new JsonObjectIterator(api, url);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DirectoryObject.Metadata next() {
            JsonObject root = this.iterator.next();
            String type = root.get("@odata.type").asString();
            String id = root.get("id").asString();
            if ("#microsoft.graph.group".equals(type)) {
                return new GroupItem.Metadata(new GroupItem(this.api, id), root);
            }
            throw new RuntimeException("The object type is currently not handled");
        }
    }
}

