/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.Site;

public final class Sites {
    private static String createSitesPath(String basePath) {
        return basePath + "/sites";
    }

    private static URL createSitesUrl(OneDriveAPI api, String basePath, ODataQuery query) {
        return new URLTemplate(Sites.createSitesPath(basePath)).build(api.getBaseURL(), query, new Object[0]);
    }

    private static URL createSitesUrl(Site site, ODataQuery query) {
        return new URLTemplate(site.getAction("/sites")).build(site.getApi().getBaseURL(), query, new Object[0]);
    }

    public static Iterator<Site.Metadata> getSites(OneDriveAPI api, ODataQuery query) {
        return new SitesIterator(api, Sites.createSitesUrl(api, "", query));
    }

    public static Iterator<Site.Metadata> getSites(Site site, ODataQuery query) {
        return new SitesIterator(site.getApi(), Sites.createSitesUrl(site, query));
    }

    private static class SitesIterator
    implements Iterator<Site.Metadata> {
        private final OneDriveAPI api;
        private final JsonObjectIterator iterator;

        public SitesIterator(OneDriveAPI api, URL url) {
            this.api = api;
            this.iterator = new JsonObjectIterator(api, url);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Site.Metadata next() {
            JsonObject jsonObject = this.iterator.next();
            String id = jsonObject.get("id").asString();
            return (Site.Metadata)Site.byId(this.api, id).new Site.Metadata().fromJson(jsonObject);
        }
    }
}

