/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveRequest;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveThumbnailSize;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveThumbnail
extends OneDriveResource {
    private static final URLTemplate GET_THUMBNAIL_URL = new URLTemplate("/drive/items/%s/thumbnails/%s/%s");
    private static final URLTemplate GET_THUMBNAIL_ROOT_URL = new URLTemplate("/drive/root/thumbnails/%s/%s");
    private static final URLTemplate GET_THUMBNAIL_CONTENT_URL = new URLTemplate("/drive/items/%s/thumbnails/%s/%s/content");
    private static final URLTemplate GET_THUMBNAIL_CONTENT_ROOT_URL = new URLTemplate("/drive/root/thumbnails/%s/%s/content");
    private final String itemId;
    private final int thumbId;
    private final OneDriveThumbnailSize size;

    OneDriveThumbnail(OneDriveAPI api, int thumbId, OneDriveThumbnailSize size) {
        super(api, "root$$" + thumbId + "$$" + size.getKey());
        this.itemId = null;
        this.thumbId = thumbId;
        this.size = Objects.requireNonNull(size);
    }

    public OneDriveThumbnail(OneDriveAPI api, String itemId, int thumbId, OneDriveThumbnailSize size) {
        super(api, itemId + "$$" + thumbId + "$$" + size.getKey());
        this.itemId = Objects.requireNonNull(itemId);
        this.thumbId = thumbId;
        this.size = Objects.requireNonNull(size);
    }

    public OneDriveThumbnail(OneDriveAPI api, String itemId, OneDriveThumbnailSize size) {
        this(api, itemId, 0, size);
    }

    public Metadata getMetadata() throws IOException {
        URL url = this.isRoot() ? GET_THUMBNAIL_ROOT_URL.build(this.getApi().getBaseURL(), this.thumbId, this.size.getKey()) : GET_THUMBNAIL_URL.build(this.getApi().getBaseURL(), this.itemId, this.thumbId, this.size.getKey());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        return new Metadata(response.getContent());
    }

    public InputStream download() throws IOException {
        URL url = this.isRoot() ? GET_THUMBNAIL_CONTENT_ROOT_URL.build(this.getApi().getBaseURL(), this.thumbId, this.size.getKey()) : GET_THUMBNAIL_CONTENT_URL.build(this.getApi().getBaseURL(), this.itemId, this.thumbId, this.size.getKey());
        OneDriveRequest request = new OneDriveRequest(url, "GET");
        OneDriveResponse response = (OneDriveResponse)request.sendRequest(this.getApi().getExecutor());
        return response.getContent();
    }

    @Override
    public boolean isRoot() {
        return this.itemId == null;
    }

    public class Metadata
    extends OneDriveResource.Metadata {
        private int height;
        private int width;
        private String url;

        public Metadata(JsonObject json) {
            super(json);
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("height".equals(memberName)) {
                    this.height = value.asInt();
                } else if ("width".equals(memberName)) {
                    this.width = value.asInt();
                } else if ("url".equals(memberName)) {
                    this.url = value.asString();
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        @Override
        public OneDriveThumbnail getResource() {
            return OneDriveThumbnail.this;
        }
    }
}

