/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;

public class ODataQuery {
    private final QueryStringBuilder builder = new QueryStringBuilder();
    private final Map<String, Set<QueryStringCommaParameter>> cache = new HashMap<String, Set<QueryStringCommaParameter>>();

    public static String get(ODataQuery query) {
        return Optional.ofNullable(query).map(ODataQuery::build).map(QueryStringBuilder::toString).orElse("");
    }

    public QueryStringBuilder build() {
        for (Map.Entry<String, Set<QueryStringCommaParameter>> entry : this.cache.entrySet()) {
            this.builder.set(entry.getKey(), entry.getValue());
        }
        return this.builder;
    }

    public ODataQuery expand(QueryStringCommaParameter value) {
        Set<QueryStringCommaParameter> set = this.getSet("$expand");
        set.add(value);
        return this;
    }

    public ODataQuery expand(QueryStringCommaParameter ... values) {
        Set<QueryStringCommaParameter> set = this.getSet("$expand");
        set.addAll(Arrays.asList(values));
        return this;
    }

    public ODataQuery expand(Set<QueryStringCommaParameter> values) {
        Set<QueryStringCommaParameter> set = this.getSet("$expand");
        set.addAll(values);
        return this;
    }

    public ODataQuery filter(String filter) {
        this.builder.set("$filter", filter);
        return this;
    }

    private Set<QueryStringCommaParameter> getSet(String key) {
        return Optional.ofNullable(this.cache.get(key)).orElseGet(() -> {
            HashSet set = new HashSet();
            this.cache.put(key, set);
            return set;
        });
    }

    public ODataQuery search(String search) {
        this.builder.set("$search", search);
        return this;
    }

    public ODataQuery select(QueryStringCommaParameter value) {
        Set<QueryStringCommaParameter> set = this.getSet("$select");
        set.add(value);
        return this;
    }

    public ODataQuery select(QueryStringCommaParameter ... values) {
        Set<QueryStringCommaParameter> set = this.getSet("$select");
        set.addAll(Arrays.asList(values));
        return this;
    }

    public ODataQuery select(Set<QueryStringCommaParameter> values) {
        Set<QueryStringCommaParameter> set = this.getSet("$select");
        set.addAll(values);
        return this;
    }

    public ODataQuery set(String key, String value) {
        this.builder.set(key, value);
        return this;
    }

    public ODataQuery set(String key, QueryStringCommaParameter value) {
        Set<QueryStringCommaParameter> set = this.getSet("$expand");
        set.add(value);
        return this;
    }

    public ODataQuery set(String key, QueryStringCommaParameter ... values) {
        Set<QueryStringCommaParameter> set = this.getSet("$expand");
        set.addAll(Arrays.asList(values));
        return this;
    }

    public ODataQuery set(String key, Set<QueryStringCommaParameter> values) {
        Set<QueryStringCommaParameter> set = this.getSet("$expand");
        set.addAll(values);
        return this;
    }

    public ODataQuery skip(int skip) {
        this.builder.set("$skip", skip);
        return this;
    }

    public ODataQuery top(int top) {
        this.builder.set("$top", top);
        return this;
    }
}

